/*!
*******************************************************************************
* @file             : seamlessMidw_DBusHandler.c
*******************************************************************************
*  - PROJECT:       : Seamless Middleware
*  - SW-COMPONENT   : Seamless Middleware DBus Handler
*  - DESCRIPTION    : Header for seamless middleware dbus service
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : 
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-------------------------
* 22.12.2017  | IPD5KOR (RBEI/ECO2) | 2.1.0 | Seamless Midw DBus Handler
******************************************************************************/
#ifndef _SEAMLESS_MIDW_DBUS_HANDLER_H_
#define _SEAMLESS_MIDW_DBUS_HANDLER_H_

#include <glib.h>
#include <gio/gio.h>

 /*****************************************************************************
 * Function:    on_spmw_bus_acquired
 * Description: Callback on D-Bus acquired
 * Parameters:  Connection , Bus name, user data
 * Return:      void
 *****************************************************************************/
 static void
 on_spmw_bus_acquired (GDBusConnection *pConnection, const gchar *pName,
                 gpointer pUserData);

 /*****************************************************************************
  * Function:    on_spmw_name_acquired
  * Description: Callback on DBus name acquired
  * Parameters:  Connection , Bus name, user data
  * Return:      void
  *****************************************************************************/
 static void
 on_spmw_name_acquired (GDBusConnection *pConnection, const gchar *pName,
                  gpointer pUserData);

 /****************************************************************************
 * Function:    on_spmw_name_lost
 * Description: Callback on D-Bus name lost
 * Parameters:  Connection , Bus name, user data
 * Return:      void
 *****************************************************************************/
 static void
 on_spmw_name_lost (GDBusConnection *pConnection, const gchar *pName,
              gpointer pUserData);

 /*****************************************************************************
 * Function:    vStartSPMWDBusService
 * Description: stats the seamless midw dbus service
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
  void  vStartSPMWDBusService();

 /****************************************************************************
  * Function:    vStopSPMWDBusService
  * Description: stops the seamless midw dbus service
  * Parameters:  void
  * Return:      void
  ****************************************************************************/
  void  vStopSPMWDBusService();

 /****************************************************************************
  * Function:    poGetSPMDBusConn
  * Description: Gives the dbus conn object of Seamless midw
  * Parameters:  void
  * Return:      GDBusConnection*
  ****************************************************************************/
  GDBusConnection*  poGetSPMDBusConn();

#endif
