/****************************************************************************
* FILE          : mdns_manager.c
* PROJECT       : Seamless Pairing For IPCM
* DESCRIPTION   : MDNS servcie manager
* AUTHOR        : svs7kor
* COPYRIGHT     : (c) 2018 Robert Bosch GmbH, Hildesheim
* DATE          : 4/09/2018
****************************************************************************/
#include "mdns_manager.h"
#include "gmain_source.h"
#include <dns_sd.h>
#include <arpa/inet.h>  //htons
#include "dlt/dlt.h"

gboolean bIsMQTTServiceRegistered = FALSE;
static GIOChannel *channel = NULL;
static DNSServiceRef *serviceRef = NULL;
static int id = 0;
GSource *Source = NULL;
DLT_DECLARE_CONTEXT(MDNS);

/*************************************************************************
 * FUNCTION     : DNSService_callback
 * DESCRIPTION  : This is a callback function for g_io_add_watch
 * PARAMETER    : GIOChannel *source,GIOCondition condition,gpointer data
 * RETURNVALUE  : gboolean
*************************************************************************/
gboolean DNSService_callback(GIOChannel *source,GIOCondition condition,gpointer data)
{
    DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("IN :"),DLT_STRING(__FUNCTION__));
	/*
	GString *buffer = g_string_new(NULL);
    GIOStatus state = G_IO_STATUS_ERROR;
    GError *error = NULL;
    state = g_io_channel_read_line_string(channel, buffer, NULL, &error);

    if (error)
    {
        DLT_LOG(MDNS,DLT_LOG_ERROR,DLT_STRING("read error :")
                ,DLT_STRING(error->message));
        g_clear_error(&error);
        g_string_free(buffer, TRUE);
        return FALSE;
    }
*/
	
	DNSServiceErrorType err = kDNSServiceErr_NoError;
    DNSServiceRef *serviceRef = (DNSServiceRef*)data;
	if(!serviceRef)
	{
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING(__FUNCTION__),
           DLT_STRING("(): null DNS Service data"));
        return FALSE;
    }		
    err = DNSServiceProcessResult((*serviceRef));
    if (err != kDNSServiceErr_NoError) 
	{
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("DNSServiceProcessResult() returned an error!")
                   ,DLT_INT(err));
    }
	else
	{
		DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("DNSServiceProcessResult() success"));
	} 
	
	DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("OUT :"),DLT_STRING(__FUNCTION__));
    return(TRUE);
}

/*************************************************************************
 * FUNCTION     : vRegisterCallBack
 * DESCRIPTION  : This is a callback function mdns register service
 * PARAMETER    : DNSServiceRef service,DNSServiceFlags flags,
 *                DNSServiceErrorType errorCode,const char * name,
 *                const char * type,const char * domain, void * context
 * RETURNVALUE  : void
*************************************************************************/
static void vDNSRegisterCallBack(DNSServiceRef service,
                                 DNSServiceFlags flags,
                                 DNSServiceErrorType errorCode,
                                 const char * name,
                                 const char * type,
                                 const char * domain,
                                 void * context)
{
#pragma unused(flags)
#pragma unused(context)

    DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("IN :"),DLT_STRING(__FUNCTION__));
    if (errorCode != kDNSServiceErr_NoError)
    {
        DLT_LOG(MDNS,DLT_LOG_ERROR,DLT_STRING("vRegisterCallBack returned :")
                ,DLT_INT(errorCode));
    }
    else
    {
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("REGISTERED NAME :")
                ,DLT_STRING(name));
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("REGISTERED type :")
                ,DLT_STRING(type));
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("REGISTERED domain :")
                ,DLT_STRING(domain));
    }
}

/*************************************************************************
 * FUNCTION     : MQTT_DNSServiceRegister
 * DESCRIPTION  : This is registers a servcie on port mentioned
 * PARAMETER    : void
 * RETURNVALUE  : DNSServiceErrorType
*************************************************************************/
gboolean MDNSRegister(char* name, char* type, guint32 port)
{
    DLT_REGISTER_CONTEXT(MDNS, "MDNS","MDNS Register");
    DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("IN :"),DLT_STRING(__FUNCTION__));
    gboolean bReturn = FALSE;
    DNSServiceErrorType error;
    serviceRef =(DNSServiceRef*)malloc(sizeof(DNSServiceRef));
    memset((void*)serviceRef, 0 , sizeof(DNSServiceRef));
    error = DNSServiceRegister(serviceRef,
                               0,                  // no flags
                               0,                  // all network interfaces
                               name,         // name
                               type,       // service type
                               "",                 // register in default domain(s)
                               NULL,               // use default host name
                               htons(port),        // port number
                               0,                  // length of TXT record
                               NULL,               // no TXT record
                               vDNSRegisterCallBack, // call back function
                               NULL);              // no context

    if (error == kDNSServiceErr_NoError)
    {
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("*** Err_NoError**"));
        int dns_sd_fd  =  DNSServiceRefSockFD((*serviceRef));
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("dns_sd_fd :")
                ,DLT_INT(dns_sd_fd));
        channel = g_io_channel_unix_new(dns_sd_fd);
		Source = g_io_create_watch(channel, G_IO_IN);
		g_source_set_callback(Source, (GSourceFunc) DNSService_callback, (gpointer)serviceRef, NULL);
		GMainLoop *mainLoop = poGetMainLoop();
		if(mainLoop)
		{
			DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("Gmainloop is not null"));
                id = g_source_attach(Source,g_main_loop_get_context(poGetMainLoop()));
		DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("result of source attach: "),DLT_INT(id));
		}
		else{
			DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("Gmainloop null"));
		}
        //g_io_add_watch(channel,G_IO_IN ,(GIOFunc)DNSService_callback,serviceRef);
        bReturn = TRUE;
    }
    else{
        //
        DLT_LOG(MDNS,DLT_LOG_ERROR,DLT_STRING("***KDNSServiceErr**"));
    }
    return bReturn;
}

/*************************************************************************
 * FUNCTION     : MQTT_DNSServiceDeRegister
 * DESCRIPTION  : This function deregisters the mdns service
 * PARAMETER    : void
 * RETURNVALUE  : void
*************************************************************************/

void MDNSDeRegister()
{
    DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("IN :"),DLT_STRING(__FUNCTION__));
	GError *error = NULL;
        GIOStatus l_eChannelStatus;
        if(Source)
        {
            if(id != 0)
            {
                g_source_remove(id);
                id = 0;
            }
            g_source_destroy(Source);
            DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("Source destroyed"));
            g_source_unref(Source);
            Source = NULL;
        }
        else
        {
            DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("Source not destroyed"));
        }
	if(channel){
		DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("valid channel"));
                l_eChannelStatus = g_io_channel_shutdown(channel, FALSE, &error);
                if(l_eChannelStatus == G_IO_STATUS_NORMAL)
                {
                    DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("MDNSDeRegister: Channel shut down"));
                    g_io_channel_unref(channel);
                    channel = NULL;
                }
                else
                {
                    DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("MDNSDeRegister: Channel shut down error:"),
                            DLT_INT(l_eChannelStatus));
                }
	}
	else{
		DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("channel is NULL"));
	}
	if(error)
	{
		//ERROR
		DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("Error closing the GIO channel "),
									DLT_STRING(error->message));
		g_clear_error(&error);
	}

    if(serviceRef)
    {
        DLT_LOG(MDNS,DLT_LOG_INFO,DLT_STRING("Free the DNSServiceRef "));
        DNSServiceRefDeallocate((*serviceRef));
        free(serviceRef);
        serviceRef = NULL;
    }
}
