/*!
*******************************************************************************
* @file             : seamless_settings.h
*******************************************************************************
*  - PROJECT:       : Seamless pairing Middleware
*  - SW-COMPONENT   : SPMA
*  - DESCRIPTION    : Header for seamless_settings.c
*  - COPYRIGHT      : &copy; 2018 Robert Bosch Engineering & Business Solutions
*  - Documents      : NA
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
* 04.09.2018 | ipd5kor      | 1.0.0 | Intial implementation
******************************************************************************/
#include <glib.h>

#define MAX_CONF_SIZE 128

/*********************************************************************
 * FUNCTION:    bLoadConfig
 * DESCRIPTION: Function to load key file from seamless_pair.conf
 * PARAMETERS:  void
 * RETURNS:     TRUE, if key file loaded successfuly
                FALSE, if failed to load key file
**********************************************************************/
gboolean bLoadConfig();

/*********************************************************************
 * FUNCTION:    bGetSPMIntegerSetting
 * DESCRIPTION: Method to get a Integer type setiing from conf
 * PARAMETERS:  param, value
 * RETURNS:     TRUE,  if value fetched successfuly
                FALSE, if failed to load conf / fetch value
**********************************************************************/
gboolean bGetSPMIntegerSetting( gchar* param,
                                gint*  value);

/************************************************************************
 * FUNCTION:    bGetSPMStringSetting
 * DESCRIPTION: Method to get a string type setiing from conf
                The method will not take care to allocate or
                deallocate memory to its paramaters. Calling function
                shall take care of assigning enough size for the 'value'
               'arg'. MAX_CONF_ITEM_SIZE is recommended size.
 * PARAMETERS:  param, value
                Memory shall be pre-assigned to 'value' arg
 * RETURNS:     TRUE,  if value fetched successfuly
                FALSE, if failed to load conf / fetch value
*************************************************************************/
gboolean bGetSPMStringSetting( gchar* param,
                               gchar* value );


/*********************************************************************
 * FUNCTION:    vUnloadConfig
 * DESCRIPTION: Function to unload key file
 * PARAMETERS:  void
 * RETURNS:     void
**********************************************************************/
void vUnloadConfig();
