/*!
***********************************************************************************
* @file             : seamless_data.h
***********************************************************************************
*  - PROJECT:       : SEAMLESS PAIRING
*  - SW-COMPONENT   : FC_SEAMLESSPAIRING_IPCM
*  - DESCRIPTION    : Seamless pairing data structures
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      :
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|---------------------------
* 24.01.2017  | IPD5KOR (RBEI/ECO2) | 2.1.0 | Added various data definitions of SP
***********************************************************************************/

#ifndef _SEAMLESS_PAIRING_DATA_H_
#define _SEAMLESS_PAIRING_DATA_H_ 


#define WPA_KEY_LENGTH 63
#define SSID_LENGTH    32
#define SESSION_ID_LENGTH  64
#define MAX_DEVICE_NAME  255 
#define MAX_MAC_ADDR  63
#define MAX_HUID_LENGTH 20
#define HASH_LEN 64
#define MAX_IPV4_LENGTH 16
#define MAX_PORT_LEN 5
#define TIME_LEN 20

typedef struct
{
   char* ssid[SSID_LENGTH+1];
   char* wpa_key[WPA_KEY_LENGTH+1];
   char* mode;
   char* type;
} WifiInfo;

typedef struct
{
   char  wpa_key[WPA_KEY_LENGTH+1];
   char  hex_session_id[SESSION_ID_LENGTH+1];
   char  ssid[SSID_LENGTH + 1];
   char  huid[MAX_HUID_LENGTH + 1]; 
   char  ipv4[MAX_IPV4_LENGTH];
   char  port[MAX_PORT_LEN+1];
   char  hashAlgorithm[10];
   unsigned char certificateHash[HASH_LEN+1];
   unsigned char issuerNameHash[HASH_LEN+1];
   unsigned char issuerKeyHash[HASH_LEN+1]; 
   unsigned char serialNumber[HASH_LEN+1];
   int serialNumberLen;
} QRData;

typedef struct 
{
  char device_name[MAX_DEVICE_NAME+1]; 
  char ssid[SSID_LENGTH+1];
  char psk[WPA_KEY_LENGTH+1];
  char bssid[MAX_MAC_ADDR+1];
  char pair_time[TIME_LEN+1];
  unsigned char* cert;
  size_t  certLength;
  char*   stunnelCertName;
  char serialnumber[HASH_LEN+1];
} CurrentDeviceInfo;

#endif
