#include <glib.h>
#include <gio/gio.h>
#include "dlt/dlt.h"
#include "SeamlessMidw_SPS_DBusHandler.h"
#include "seamlessMidw_DBusHandler.h"
#include "seamless_controller.h"
#include "SeamlessMidw_HMI_enums.h" 
#include "SeamlessMidw_HMI_DBusHandler.h"

DLT_DECLARE_CONTEXT(SPM_SPS);

static SeamlessMidwSeamlessPairingServer* pSeamlessMidwSPSProxyObj = NULL;

/****************************************************************************
* Function:     bExportSeamlessMidw_ServerIface
* Description:  This method exposes the server Interface of Seamless Midw
* Parameters:   void
* Return:       gboolean
******************************************************************************/
gboolean bExportSeamlessMidw_ServerIface()
{ 
    DLT_REGISTER_CONTEXT(SPM_SPS,"SMSS",
                        "Seamless midw server interface logging");
    DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"),DLT_STRING(__FUNCTION__));

    if (poGetSeamlessMidwSPSProxy() == NULL)
    {
         DLT_LOG(SPM_SPS, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__), DLT_STRING(
	            "():seamless , failed to expose interface"));
         return FALSE;
    }

    GError *error = NULL;
    GDBusConnection* connection = NULL;

    if((connection = poGetSPMDBusConn()) == NULL)
    {
        DLT_LOG(SPM_SPS, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
            DLT_STRING("(): poGetSPMDBusConn returned NULL"));
        return FALSE;
    }

    if (!g_dbus_interface_skeleton_export(
                G_DBUS_INTERFACE_SKELETON(poGetSeamlessMidwSPSProxy()),
                connection,
                "/com/bosch/SeamlessMiddleware/SeamlessPairingServer",
                &error) )
    {
        if (error)
        {
              DLT_LOG(SPM_SPS, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__), 
  	         DLT_STRING("():Seamless Server interface export error"),
	    	                             DLT_STRING(error->message));
              g_clear_error(&error);
        }
        else DLT_LOG(SPM_SPS, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__), 
 	    DLT_STRING("():SP server  interface export error"));
        return FALSE;
    }
    else 
    {
        DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__), DLT_STRING(
             "():SeamlessMidw Server interface skeleton exported successfully"));
    }

    g_signal_connect(poGetSeamlessMidwSPSProxy(),"handle-proccess-app-message",
                      G_CALLBACK (handle_proccess_app_message), NULL);

    g_signal_connect(poGetSeamlessMidwSPSProxy(),"handle-spsconnection-state",
                       G_CALLBACK (handle_SPS_connection_state), NULL);
    
     
    DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),DLT_STRING(__FUNCTION__));
    return TRUE;
}

/***************************************************************************
* Function:    poGetSeamlessMidwSPSProxy
* Description: Creates and returns SeamlessPairing proxy object
* Parameters:  void
* Return:      SeamlessMidwSeamlessPairingServer* 
*****************************************************************************/
SeamlessMidwSeamlessPairingServer* poGetSeamlessMidwSPSProxy()
{
     if(pSeamlessMidwSPSProxyObj == NULL)
     { 
        pSeamlessMidwSPSProxyObj = 
              seamless_middleware_seamless_pairing_server_skeleton_new();
     }
     return pSeamlessMidwSPSProxyObj;
}

/***************************************************************************
* Function:    bSPSIfaceAvailable
* Description: Provides the SPS Dbus Interface availability status
* Parameters:  void
* Returns:     gboolean
*****************************************************************************/
gboolean bSPSIfaceAvailable()
{
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"),DLT_STRING(__FUNCTION__));
     if(pSeamlessMidwSPSProxyObj == NULL)
         return FALSE;
     else
         return TRUE;
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),DLT_STRING(__FUNCTION__));
} 

/*************************************************************************
* Function:    vUnExportSeamlessMidw_SPSIface
* Description: unexports the Seamless SPS Interface
* Parameters:  void
* Return:      void
**************************************************************************/
void vUnExportSeamlessMidw_SPSIface()
{
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"),
                            DLT_STRING(__FUNCTION__));

     if(pSeamlessMidwSPSProxyObj != NULL)
     {
        g_dbus_interface_skeleton_unexport(
		           G_DBUS_INTERFACE_SKELETON(pSeamlessMidwSPSProxyObj));
        g_clear_object(&pSeamlessMidwSPSProxyObj);
     }

     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),
                            DLT_STRING(__FUNCTION__));
     DLT_UNREGISTER_CONTEXT(SPM_SPS);
}  

/*************************************************************************
* Function:    bStartSeamlessPairingServer
* Description: This method starts the seamless pairing
               server on the container
* Parameters:  connInfo
* Return:      gboolean
***************************************************************************/ 
gboolean bStartSeamlessPairingServer(GVariant* connInfo)
{
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"),
                  DLT_STRING(__FUNCTION__));
     if(pSeamlessMidwSPSProxyObj == NULL)
     {
         DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                   DLT_STRING("(): NULL Proxy"));      
         return FALSE; 
     }
     seamless_middleware_seamless_pairing_server_emit_start_spserver (
                                                    pSeamlessMidwSPSProxyObj,
                                                                    connInfo
                                                                      );    
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),
                 DLT_STRING(__FUNCTION__));
     return TRUE; 
}
   
/*************************************************************************
* Function:    vStopSeamlessPairingServer
* Description: This method stops the seamless pairing
               server on the container
* Parameters:  certPath, pairStatus
* Return:      void
**************************************************************************/
void vStopSeamlessPairingServer( gchar*     certPath, 
                                 SP_Status pairStatus)
{
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"),
                          DLT_STRING(__FUNCTION__));
     if((!certPath) || (!pSeamlessMidwSPSProxyObj))
     {
         DLT_LOG(SPM_SPS, DLT_LOG_ERROR, DLT_STRING(__FUNCTION__),
                       DLT_STRING("(): NULL Proxy or cert path"));
     }  
     else
     {
         seamless_middleware_seamless_pairing_server_emit_stop_spserver(
                                              pSeamlessMidwSPSProxyObj,
                                                  (guint16) pairStatus,
                                                           certPath    );
     }
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),
                  DLT_STRING(__FUNCTION__));
}      

/****************************************************************************
* Function:    bSendMessageToApp
* Description: This method sends the app message to seamless server
* Parameters:  appMessage
* Return:      gboolean
****************************************************************************/
gboolean bSendMessageToApp( GVariant* msg) 
{
    DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"), 
                             DLT_STRING(__FUNCTION__));

    if(pSeamlessMidwSPSProxyObj == NULL)
    {
        DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                                    DLT_STRING("(): NULL Proxy"));
        return FALSE;
    }

    if(!msg)
    {
         DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                                DLT_STRING("(): NULL  message"));
         return FALSE;
    } 

    /*       if((!key) || (!value))
    {
       DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
                                  DLT_STRING("(): NULL input(s))"));
        return FALSE;
    }
 
    GVariantBuilder builder;

    g_variant_builder_init(&builder, G_VARIANT_TYPE("a{ss}"));
    g_variant_builder_add(&builder, "{ss}", key, value );
    appMessage = g_variant_builder_end(&builder);
    */
    seamless_middleware_seamless_pairing_server_emit_send_message_to_app(
                                                    pSeamlessMidwSPSProxyObj,
                                                       msg );

    DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),
                             DLT_STRING(__FUNCTION__));
    return TRUE;
}
      
/***************************************************************************
* Function:    handle_proccess_app_message
* Description: This method proccess the data recieved from Smartphone app
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
****************************************************************************/
gboolean  handle_proccess_app_message( 
                         SeamlessMidwSeamlessPairingServer *object,
                         GDBusMethodInvocation *invocation,
                         gchar*                 key,
                         GVariant*              value,
                         gpointer               user_data )
{
    DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"),
                         DLT_STRING(__FUNCTION__));

    vProcessAppMsg(key, value); 
 
    seamless_middleware_seamless_pairing_server_complete_proccess_app_message(
                                                                       object, 
                                                                   invocation );

    DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),
                 DLT_STRING(__FUNCTION__));
    return TRUE;
}

/***************************************************************************
* Function:    handle_SPS_connection_state
* Description: This method handles the SPS Connection state
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
****************************************************************************/
gboolean handle_SPS_connection_state( 
         SeamlessMidwSeamlessPairingServer* object,
         GDBusMethodInvocation*  invocation,
         guint16                 connState,
         gpointer                user_data )
{
     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("+"),
                  DLT_STRING(__FUNCTION__));

     seamless_middleware_seamless_pairing_server_complete_spsconnection_state(
                                                                       object,
                                                                    invocation);
     if( (SPServerConnectionState) connState == SPS_CLIENT_DISCONNECTED )  
     {
          DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
               DLT_STRING("(): Received client disconnected state"));
          vCloseSeamlessSession(SP_COMPLETED, SP_ERR_CLIENT_DISCONNECTED);      
     }

     if( (SPServerConnectionState) connState == SPS_START_FAILED ) 
     {
          DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
               DLT_STRING("(): Error starting SP Server"));
          vCloseSeamlessSession(SP_COMPLETED, SP_ERR_SERVER_ERROR);
     }

     if( (SPServerConnectionState) connState == SPS_CLIENT_CONNECTED)
     {
          DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
               DLT_STRING("(): Received client connected trigger"));
          GVariant* deviceInfo = pGetCurrentDeviceInfo();

          vEmitSeamlessPairingStatus( SP_AUTHENTICATED,
                                      SP_ERR_NO_ERROR,
                                      deviceInfo );   
          vUpdateSPConnectedStatus(TRUE);         
     }

     DLT_LOG(SPM_SPS, DLT_LOG_INFO, DLT_STRING("-"),
                  DLT_STRING(__FUNCTION__));
     return TRUE;
}
    
