#ifndef _SEAMLESS_MIDW_SPS_DBUSHANDLER_H_
#define _SEAMLESS_MIDW_SPS_DBUSHANDLER_H_

#include "seamlessMidw_SPS_autogen.h"

typedef enum
{
    SPS_START_SUCCESS = 0,
    SPS_START_FAILED,
    SPS_CLIENT_CONNECTED,
    SPS_CLIENT_DISCONNECTED,
    SPS_STOP_SUCCESS,
    SPS_STOP_FAILED
}SPServerConnectionState;

typedef enum
{
   PAIR_SUCCESS = 0,
   PAIR_FAILED
}SP_Status;

/***************************************************************************
* Function:     bExportSeamlessMidw_ServerIface
* Description:  This method exposes the server Interface of Seamless Midw
* Parameters:   void
* Return:       gboolean
****************************************************************************/
gboolean bExportSeamlessMidw_ServerIface();

/**************************************************************************
* Function:    poGetSeamlessMidwSPSProxy
* Description: Creates and returns SeamlessPairing proxy object
* Parameters:  void
* Return:      SeamlessMidwSeamlessPairingServer*
***************************************************************************/
SeamlessMidwSeamlessPairingServer* poGetSeamlessMidwSPSProxy();

/**************************************************************************
* Function:    vUnExportSeamlessMidw_SPSIface
* Description: unexports the Seamless SPS Interface
* Parameters:  void
* Return:      void
**************************************************************************/
void vUnExportSeamlessMidw_SPSIface();  

/**************************************************************************
* Function:    handle_proccess_app_message
* Description: This method handles the UpdateTrustedDevice
               request from HMI
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
***************************************************************************/
gboolean  handle_proccess_app_message( 
                      SeamlessMidwSeamlessPairingServer *object,
                      GDBusMethodInvocation             *invocation,
                      gchar*                             key,
                      GVariant*                          value,
                      gpointer                           user_data );

/***************************************************************************
* Function:    handle_SPS_connection_state
* Description: This method handles the SPS Connection state
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
****************************************************************************/
gboolean handle_SPS_connection_state(
         SeamlessMidwSeamlessPairingServer* object,
         GDBusMethodInvocation*  invocation,
         guint16                 state,
         gpointer                user_data );

/**************************************************************************
* Function:    bSPSIfaceAvailable
* Description: Provides the SPS Dbus Interface availability status
* Parameters:  void
* Returns:     gboolean
****************************************************************************/
gboolean bSPSIfaceAvailable();

/*************************************************************************
* Function:    bStartSeamlessPairingServer
* Description: This method starts the seamless pairing
               server on the container
* Parameters:  connInfo
* Return:      gboolean
**************************************************************************/
gboolean bStartSeamlessPairingServer(GVariant* connInfo);

/*************************************************************************
* Function:    vStopSeamlessPairingServer
* Description: This method stops the seamless pairing
               server on the container
* Parameters:  certPath, pairStatus
* Return:      void
**************************************************************************/
void vStopSeamlessPairingServer( gchar*     certPath,
                                 SP_Status pairStatus 
                               );

/**************************************************************************
* Function:    bSendMessageToApp
* Description: This method sends the app message to seamless server
* Parameters:  appMessage
* Return:      gboolean
**************************************************************************/
gboolean bSendMessageToApp( GVariant* msg);

#endif
