#ifndef _SEAMLESS_MIDW_HMI_DBUSHANDLER_H_
#define _SEAMLESS_MIDW_HMI_DBUSHANDLER_H_

#include "seamless_HMI_autogen.h"

/****************************************************************************
* Function:     bExportSeamlessHMI
* Description:  This method exposes the seamless pairing HMI Interface
* Parameters:   void
* Return:       gboolean
****************************************************************************/
gboolean bExportSeamlessHMI();

/****************************************************************************
* Function:    poGetSeamlessHMIProxyObj
* Description: Creates and returns SeamlessPairing proxy object
* Parameters:  void
* Return:      CertificateManager*
*****************************************************************************/
SeamlessMiddlewareHMI* poGetSeamlessHMIProxyObj();

/*************************************************************************
* Function:    vUnExportSeamlessHMI
* Description: unexports the Seamless HMI Interface
* Parameters:  void
* Return:      void
**************************************************************************/
void vUnExportSeamlessHMI();

/*************************************************************************
* Function:    handle_update_trusted_device
* Description: This method handles the UpdateTrustedDevice
                request from HMI
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
***************************************************************************/
gboolean
handle_update_trusted_device( SeamlessMiddlewareHMI *object,
                              GDBusMethodInvocation *invocation,
                              guchar    action,
                              GVariant* deviceInfo,
                              gpointer user_data
                            );

/**************************************************************************
* Function:    vUpdateTrustedDeviceList
* Description: This method updates the property 'TrustedDeviceList'
* Parameters:  devices list as GVariant
* Return:      void
***************************************************************************/
void vUpdateTrustedDeviceList(GVariant* deviceList);
 
/**************************************************************************
* Function:    vEmitSeamlessPairingStatus
* Description: This method emits the signal 'SeamlessPairingStatus'
* Parameters:  status, error code, deviceInfo
* Return:      void
***************************************************************************/
void vEmitSeamlessPairingStatus( guint16   status,
                                 guint16   errorCode,
                                 GVariant* deviceInfo );

/***************************************************************************
* Function:    bEmitQRCodeUpdate
* Description: This method emits the signal 'QRCodeUpdate'
* Parameters:  qrCodeData
* Return:      gboolean
****************************************************************************/
gboolean bEmitQRCodeUpdate(char* qrFileName);

#endif
