#ifndef __SP_SYSTEM_SETTINGS_DBUS_HANDLER_H__
#define __SP_SYSTEM_SETTINGS_DBUS_HANDLER_H__

#include <glib.h>
#include <gio/gio.h>
#include "SystemSettings_auto_gen.h"

/***************************************************************************
* Function:     bExportSPFactoryReset
* Description:  This method exposes the seamless pairing
                Factory Reset interface
* Parameters:   void
* Return:       gboolean
****************************************************************************/
gboolean bExportSPFactoryReset();

/*************************************************************************
* Function:    vUnExportSPFactoryReset
* Description: This method unexports the Factory reset interface
* Parameters:  void
* Return:      void
**************************************************************************/
void vUnExportSPFactoryReset();

/**************************************************************************
* Function:    handle_finalize_system_setting
* Description: This method handles the FinalizeSystemSetting
               request from the Factory Reset
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
****************************************************************************/
gboolean  handle_finalize_system_setting( Diagnosis1SystemSettings1 *object,
                                          GDBusMethodInvocation *invocation,
                                          const gchar *sysSetID,
                                          const gchar *sysSetType,
                                          GVariant *extendedData,
                                          guint cookie
                                        );

/**************************************************************************
* Function:    handle_execute_system_setting
* Description: This method handles the FinalizeSystemSetting
               request from the Factory Reset
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
****************************************************************************/
gboolean  handle_execute_system_setting( Diagnosis1SystemSettings1 *object,
                                         GDBusMethodInvocation *invocation,
                                         const gchar *sysSetID,
                                         const gchar *sysSetType,
                                         GVariant *extendedData,
                                         guint cookie
                                       );

/**************************************************************************
* Function:    handle_prepare_system_setting
* Description: This method handles the FinalizeSystemSetting
               request from the Factory Reset
* Parameters:  proxy object, invocation pointer, data, user data
* Return:      gboolean
****************************************************************************/
gboolean  handle_prepare_system_setting( Diagnosis1SystemSettings1 *object,
                                         GDBusMethodInvocation *invocation,
                                         const gchar *sysSetID,
                                         const gchar *sysSetType,
                                         GVariant *extendedData,
                                         guint cookie
                                       );


#endif
