#ifndef _SEAMLESS_CONNMAN_DBUSHANDLER_H_
#define _SEAMLESS_CONNMAN_DBUSHANDLER_H_

#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include "connman_manager_gdbus_fi.h"
#include "connman_notofication_gdbus_fi.h"

void vOnSpmwSystemNameAcquired( GDBusConnection *pConnection,
                                const gchar     *pName,
                                gpointer        pUserData );

void vUnwatchConnmanService();

GDBusConnection* poGetSPMSystemBusConn();

void vHandleReleaseCB (NetConnmanNotification *object,
                       GDBusMethodInvocation *invocation);

void vHandleUpdateCB (NetConnmanNotification *object,
                      GDBusMethodInvocation *invocation,
                      GVariant *arg_fields);

void vOnNetConnmanNotiBusAcquired (GDBusConnection *connection,
                                   const gchar *name,
                                   gpointer user_data);

void vOnNetConnmanNotiNameAcquired (GDBusConnection *connection,
                                    const gchar *name,
                                    gpointer user_data);


void vOnNetConnmanNotiNameLost (GDBusConnection *connection,
                                const gchar *name,
                                gpointer user_data);

void vStartNetConnmanNotificationService ();

void vCreateSessionCallback(GObject *source_object,
                            GAsyncResult *res,
                            gpointer user_data);

void vCreateSession();

void vNetConnmanManagerProxyCreatedCB (GObject *source_object,
                                       GAsyncResult *res,
                                       gpointer user_data);

void vNetConnmanNameAppeared (GDBusConnection *connection,
                              const gchar *name,
                              const gchar *name_owner,
                              gpointer user_data);

void vNetConnmanNameVanished (GDBusConnection *connection,
                              const gchar *name,
                              gpointer user_data);

gboolean bStartSPMWConnmanService();


#endif
