/*
 * profileRenault_VCANClient.h
 *
 *  Created on: 30.05.2017
 *      Author: akm7cob
 */

#include "profileRenault_VCANClient.h"

#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#include "midw_common_if.h"

// Interfaces for CAN Read
#define CSM_S_IMPORT_INTERFACE_GENERIC
#include "csm_if.h"


namespace profileMngr{

profileRenault_VCANClient *profileRenault_VCANClient::m_pThisInterface = NULL;

/******************************************************************************/
/* FUNCTION     ~profileRenault_VCANClient                              		  */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
profileRenault_VCANClient::profileRenault_VCANClient()
{
	m_pCSMInterface = new CSMInterface();
	m_pThisInterface = this;
}

/******************************************************************************/
/* FUNCTION     ~profileRenault_VCANClient                              		  */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
profileRenault_VCANClient::~profileRenault_VCANClient()
{
	delete m_pCSMInterface;
}

profileRenault_VCANClient &profileRenault_VCANClient::getInstance()
{
	return *m_pThisInterface;
}

/******************************************************************************/
/* FUNCTION     writeCurrentUserSetting                                              */
/******************************************************************************/
/**
*  \brief       Function to write Current UserID value to CSM VCAN.
*
*  \param       UserID
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profileRenault_VCANClient::writeCurrentUserSetting(unsigned char userID)
{
	bool returnValue = FALSE;
    	return returnValue;
}

/******************************************************************************/
/* FUNCTION     writeCSMSignal                                     		  */
/******************************************************************************/
/**
*  \brief       Function to write user change SW information value to CSM VCAN.
*
*  \param       signalId, pvNewSignalData, dataBufferLength
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profileRenault_VCANClient::writeCSMSignal(tU32  signalId, void *pvNewSignalData, tU8   dataBufferLength )
{
	bool returnValue = FALSE;
	tU32 csmHandle = 0;
	if (m_pCSMInterface && (signalId !=0))
	{
		if(CSM_C_NO_ERROR <= (m_pCSMInterface->CSM_lSignalWrite((tVoid *)&csmHandle,
											 (tU32) signalId,
											 (tVoid* ) pvNewSignalData,
											 (tU8) dataBufferLength,
											 (tU8) CSM_C_TX_AS_CONFIGURED) ))
		{
			returnValue = TRUE;
		}
		else
		{
			//ETG_TRACE_USR4((" CSM-IF   :: _bWriteCsmSignal(): ................ write Csm failed!"));
		}
	}
	return returnValue;
}

}
