/*
 * profilePIVI_VCANClient.h
 *
 *  Created on: 30.05.2017
 *      Author: akm7cob
 */
#ifndef PROFILEPIVI_VCANCLIENT_H
#define PROFILEPIVI_VCANCLIENT_H

#include "pivi/core/ProfileCfgComp.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

class CSMInterface;

namespace pivi { namespace core {

enum enInitialFlag
{
	en_Initialized=0,
	en_Initializing
};

enum enUserRegInfo
{
	en_NotRegistered=0,
	en_Registered
};

enum enUser
{
	en_User1=1,
	en_User2,
	en_User3,
	en_User4
};

enum enCopyStatus
{
	en_Copy=0,
	en_NotCopy
};

enum enCopyUser
{
	en_NotCopyUser=0,
	en_CopyUser1,
	en_CopyUser2,
	en_CopyUser3,
	en_CopyUser4
};

enum enCSMSignalCopySetting
{
	en_CSMSignalCopyDriveSetting=0,
	en_CSMSignalCopyITSSetting
};

    class profilePIVI_VCANClient
    {
    private:
        CSMInterface* m_pCSMInterface;
		
		static profilePIVI_VCANClient *m_pThisInterface;
		
		enInitialFlag m_enInitialFlag;

		static void csmSignalCallback(void * pHandle, tU32 u32SignalId, tU32 u32SignalStatus);
		
		void initCSMSignalsCallback();

		bool writeCSMSignal(tU32  dwSignalId, void *pvNewSignalData, tU8   bDataBufferLength );
		void getVCANEffectvieUserID(unsigned char & UserID);


    public:
        profilePIVI_VCANClient();
        virtual ~profilePIVI_VCANClient();
        void sendConfirmationToIDM();
        static profilePIVI_VCANClient &getInstance();

		// const methods do not change the class member vars
		bool readUserIdSignal(unsigned char &keyID) const;
		bool readLoginKeyLinkStatus(bool &loginKeyLinkStatus) const;
		bool readLoginUserChangePermitFlag(bool &loginUserChangePermitFlag) const;

		enInitialFlag getInitialFlagStatus(){return m_enInitialFlag;}

		// methods to write VCAN signals
		bool writeInitialFlag(enInitialFlag);
		bool writeLoginKeyLinkSetting();
		bool writeCurrentLoginUserInfo(unsigned char currentUserInfo);
		bool writeUserRegistrationInfo(unsigned char userId, enUserRegInfo userRegInfo);
		bool toggleUserChangeSW(unsigned char currentUserId);
		bool writeCopyFromUser(unsigned char userId);
		bool writeCopyToUser(unsigned char userId);
		bool writeCSMCopySetting(enCSMSignalCopySetting csmSignalCopySetting, enCopyStatus copystatus);
		static bool ProfileStubAvailability;
    };
}}

#endif

