/*
 * profilePIVI_VCANClient.h
 *
 *  Created on: 30.05.2017
 *      Author: akm7cob
 */

#include "pivi/core/profilePIVI_VCANClient.h"
#include "pivi/core/ServicePIVI.h"
#include "pivi/config/profilePIVIDefines.h"
// Interfaces for CAN Read

#define CSM_S_IMPORT_INTERFACE_GENERIC
#include "csm_if.h"
#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#include "midw_common_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include <pivi/core/profilePIVITrace.h>
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP_PIVI
#include "trcGenProj/Header/profilePIVI_VCANClient.cpp.trc.h"
#endif


namespace pivi { namespace core {

profilePIVI_VCANClient *profilePIVI_VCANClient::m_pThisInterface = NULL;
bool profilePIVI_VCANClient::ProfileStubAvailability = false;

/******************************************************************************/
/* FUNCTION     ~profilePIVI_VCANClient                              		  */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
profilePIVI_VCANClient::profilePIVI_VCANClient()
{
	m_pCSMInterface = new CSMInterface();
	m_pThisInterface = this;
	m_enInitialFlag = en_Initializing;
	ProfileStubAvailability = false;

	initCSMSignalsCallback();
}

/******************************************************************************/
/* FUNCTION     ~profilePIVI_VCANClient                              		  */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
profilePIVI_VCANClient::~profilePIVI_VCANClient()
{
	delete m_pCSMInterface;
}

profilePIVI_VCANClient &profilePIVI_VCANClient::getInstance()
{
	return *m_pThisInterface;
}

/******************************************************************************/
/* FUNCTION     initCSMSignalsCallback                                       */
/******************************************************************************/
/**
*  \brief       Function to Initialize CSM signal handler
*
*  \param       signalId
*
*  \return      none
*/
/******************************************************************************/
void profilePIVI_VCANClient::initCSMSignalsCallback()
{
	uint32 csmHandle;

	// LogIn Key Link Status Value read
	/*if (m_pCSMInterface->CSM_lSignalCallbackInit((void *)&csmHandle, CSM_C_ASIG_RX_LogIn_Key_Link_Status,csmSignalCallback) < CSM_C_NO_ERROR)
	{
		// error !! csmSignalCallback() will not be called
		ETG_TRACE_ERR(("vOnNewAppState() CMF1 - ERROR: CSM_C_ASIG_RX_LogIn_Key_Link_Status-Callbackinit failed !"));
	}

	// User Identification Key Value read
	if (m_pCSMInterface->CSM_lSignalCallbackInit((void *)&csmHandle, CSM_C_ASIG_RX_UserIdentification,csmSignalCallback) < CSM_C_NO_ERROR)
	{
		// error !! csmSignalCallback() will not be called
		ETG_TRACE_ERR(("vOnNewAppState() CMF1 - ERROR: CSM_C_ASIG_RX_UserIdentification-Callbackinit failed !"));
	}*/

}


/******************************************************************************/
/* FUNCTION     readUserIdSignal                                             */
/******************************************************************************/
/**
*  \brief       Function to read UserIdSignal from CSM
*
*  \param       signalId
*
*  \return      bool
*/
/******************************************************************************/
bool profilePIVI_VCANClient::readUserIdSignal(unsigned char &keyID) const
{
	bool result = false;
	uint8  au8Data_ReadBuffer[1];
	tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
	uint32 csmHandle;

	/*if ( CSM_C_NO_ERROR <= ( m_pCSMInterface->CSM_lSignalRead( (void*)&csmHandle, CSM_C_ASIG_RX_UserIdentification,
			&au8Data_ReadBuffer[0],  1,
			&u32StatusRead)))
	{
		if(CSM_C_SIGNAL_ARRIVED == u32StatusRead)   // CSM_C_SIGNAL_DATA_INVALID
		{
			keyID = au8Data_ReadBuffer[0];
			ETG_TRACE_USR4(("readUserIdSignal userId:%d ",keyID));
			result = true;
		}
		else
		{
			ETG_TRACE_USR4(("readUserIdSignal u32StatusRead %d ",u32StatusRead));
		}
	}
	else
	{
		ETG_TRACE_FATAL(("readUserIdSignal(): ERROR CSM API"));
	}*/
	if(result)
	{
		m_pThisInterface->sendConfirmationToIDM();
	}
	return result;
}

/******************************************************************************/
/* FUNCTION     readLoginKeyLinkStatus                                             */
/******************************************************************************/
/**
*  \brief       Function to read UserIdSignal from CSM
*
*  \param       loginKeyLinkStatus
*
*  \return      bool
*/
/******************************************************************************/
bool profilePIVI_VCANClient::readLoginKeyLinkStatus(bool &loginKeyLinkStatus) const
{
	tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
	uint32 csmHandle;

	/*if ( CSM_C_NO_ERROR <= ( m_pCSMInterface->CSM_lSignalRead( (void*)&csmHandle, CSM_C_ASIG_RX_LogIn_Key_Link_Status,
			&loginKeyLinkStatus,  1,
			&u32StatusRead)))
	{
		ETG_TRACE_USR4(("readLoginKeyLinkStatus :%d ",loginKeyLinkStatus));
		m_pThisInterface->sendConfirmationToIDM();
		return true;
	}
	else
	{
		ETG_TRACE_FATAL(("readLoginKeyLinkStatus(): ERROR CSM API"));
		return false;
	}*/
}

/******************************************************************************/
/* FUNCTION     readLoginUserChangePermitFlag                                             */
/******************************************************************************/
/**
*  \brief       Function to read UserIdSignal from CSM
*
*  \param       loginUserChangePermitFlag
*
*  \return      bool
*/
/******************************************************************************/
bool profilePIVI_VCANClient::readLoginUserChangePermitFlag(bool &loginUserChangePermitFlag) const
{
	tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
	uint32 csmHandle;

	/*if ( CSM_C_NO_ERROR <= ( m_pCSMInterface->CSM_lSignalRead( (void*)&csmHandle, CSM_C_ASIG_RX_LogIn_User_Change_Permit_Flag,
			&loginUserChangePermitFlag,  1,
			&u32StatusRead)))
	{
		ETG_TRACE_USR4(("readLoginUserChangePermitFlag :%d ",loginUserChangePermitFlag));
		m_pThisInterface->sendConfirmationToIDM();
		return true;
	}
	else
	{
		ETG_TRACE_FATAL(("readLoginUserChangePermitFlag(): ERROR CSM API"));
		return false;
	}*/
}

/******************************************************************************/
/* FUNCTION     csmSignalCallback                                             */
/******************************************************************************/
/**
*  \brief       callback function from CSM to inform about CAN signal changes
*
*  \param       pHandle, signalId, u32SignalStatus
*
*  \return      none
*/
/******************************************************************************/
void profilePIVI_VCANClient::csmSignalCallback(void* pHandle, tU32 signalId, tU32 u32SignalStatus)
{
	if(false == ProfileStubAvailability)
	{
		ETG_TRACE_USR4(("csmSignalCallback(): not possible as stub is not available"));
		return;
	}

	// tBool bSignalTimeOut     = FALSE;
	// tBool bSignalDataInvalid = FALSE;
	(void) pHandle;

	/* Check whether it is a timeout message */
	if (u32SignalStatus & CSM_C_SIGNAL_TIMEOUT)
	{
		// bSignalTimeOut = TRUE;
		ETG_TRACE_ERR(("csmSignalCallback(): CSM signal timeout"));
	}

	/* Check whether the data is valid */
	if (u32SignalStatus & CSM_C_SIGNAL_DATA_INVALID)
	{
		// bSignalDataInvalid = TRUE;
		ETG_TRACE_ERR(("csmSignalCallback(): CSM Data Invalid"));
	}

	/* Check which signal is changed ! */
	switch(signalId)
	{
		// Key id changed
	/*	case CSM_C_ASIG_RX_UserIdentification:
		{
// TODO: ASF mechanism to wakeup main thread on CSM event
			unsigned char keyID;
			m_pThisInterface->readUserIdSignal(keyID);
			ServicePIVI::getInstance().sendkeyID(keyID);
		}
		break;
		// Login Key link status
		case CSM_C_ASIG_RX_LogIn_Key_Link_Status:
		{
// TODO: ASF mechanism to wakeup main thread on CSM event
			bool loginKeyLinkStatus = false;
			m_pThisInterface->readLoginKeyLinkStatus(loginKeyLinkStatus);
			ServicePIVI::getInstance().sendLoginKeyLinkStatus(loginKeyLinkStatus);
		}
		break;*/

		default:
		break;
	}
}

/******************************************************************************/
/* FUNCTION     writeInitialFlag                                              */
/******************************************************************************/
/**
*  \brief       Function to write Initial Flag value to CSM VCAN.
*
*  \param       initialFlag
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeInitialFlag(enInitialFlag initialFlag)
{
	bool returnValue = FALSE;

	if (m_pCSMInterface)
	{
		/*returnValue = writeCSMSignal(CSM_C_ASIG_TX_Initial_Flag,
										 &initialFlag,
										 1);*/
	}
	return returnValue;
}

/******************************************************************************/
/* FUNCTION     writeLoginKeyLinkSetting                                      */
/******************************************************************************/
/**
*  \brief       Function to write Login Key Link Settings value to CSM VCAN.
*
*  \param       loginKeyLinkSetting
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeLoginKeyLinkSetting()
{
	static bool loginKeyLinkSetting = false;
	loginKeyLinkSetting = !loginKeyLinkSetting;//toggle this signal on each HMI request.start from value 1 then 0 ->  1 -> 0
	bool returnValue = FALSE;
	if (m_pCSMInterface)
	{
/*		returnValue = writeCSMSignal(CSM_C_ASIG_TX_LogIn_Key_Link_Setting,
									 &loginKeyLinkSetting,
									 1);*/
	}
	return returnValue;
}

void profilePIVI_VCANClient::getVCANEffectvieUserID(unsigned char &UserID)
{
	ETG_TRACE_USR4(("CSM incoming UID:%d ",UserID));
	if(UserID > INDEX_GUEST_PROFILE && UserID < MAX_PROFILE_PIVI )
	{
		UserID -= 1;
	}
	else if(UserID == INDEX_GUEST_PROFILE)
	{
		UserID = VCAN_GUEST_USERID;
	}
	ETG_TRACE_USR4(("CSM VCANEffectiveUID:%d",UserID));
}

/******************************************************************************/
/* FUNCTION     writeCurrentLoginUserInfo                                      	  */
/******************************************************************************/
/**
*  \brief       Function to write Current login user information value to CSM VCAN.
*
*  \param       currentUserInfo
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeCurrentLoginUserInfo(unsigned char userID)
{
	getVCANEffectvieUserID(userID);
	userID -=1;//NB: index for current login is 0-3
	ETG_TRACE_USR4(("CSM writeCurrentLoginUserInfo:%d",userID));
	bool returnValue = FALSE;

	if (m_pCSMInterface)
	{
/*		returnValue = writeCSMSignal(CSM_C_ASIG_TX_Current_Login_User_information,
					 &userID,
					 1);*/
	}
	return returnValue;
}

/******************************************************************************/
/* FUNCTION     writeUserRegistrationInfo                                     */
/******************************************************************************/
/**
*  \brief       Function to write user registration information value to CSM VCAN.
*
*  \param       userId, userRegInfo
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeUserRegistrationInfo(unsigned char userId, enUserRegInfo userRegInfo)
{
	bool returnValue = FALSE;
	tU32 signalId = 0;

	getVCANEffectvieUserID(userId);
	switch(userId)
	{
	case en_User1:
//		signalId = CSM_C_ASIG_TX_User1_registration_information;
		break;
	case en_User2:
//		signalId = CSM_C_ASIG_TX_User2_registration_information;
		break;
	case en_User3:
//		signalId = CSM_C_ASIG_TX_User3_registration_information;
		break;
	case en_User4:
//		signalId = CSM_C_ASIG_TX_User4_registration_information;
		break;
	default:
		signalId = 0;
		break;
	}

	if (m_pCSMInterface && (signalId !=0))
	{
		returnValue = writeCSMSignal(signalId, &userRegInfo, 1);
		if(returnValue)
			ETG_TRACE_USR4(("CSM write UserRegistrationInfo signal id: %x, value: %d ............ write Csm OK!                  ", signalId, userRegInfo));
	}
	return returnValue;
}

/******************************************************************************/
/* FUNCTION     toggleUserChangeSW                                     		  */
/******************************************************************************/
/**
*  \brief       Function to write user change SW information value to CSM VCAN.
*
*  \param       currentUserId
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::toggleUserChangeSW(unsigned char currentUserId)
{
	getVCANEffectvieUserID(currentUserId);
	bool returnValue = FALSE;
	tU32 signalId = 0;
	bool changeSWStatus = false;
	static bool user1SW=false, user2SW=false, user3SW=false, user4SW=false;

	switch(currentUserId)
	{
	case en_User1:
//		signalId = CSM_C_ASIG_TX_User1_change_SW;
		user1SW = !user1SW;							//Toggle user SW value
		changeSWStatus = user1SW;
		break;
	case en_User2:
//		signalId = CSM_C_ASIG_TX_User2_change_SW;
		user2SW = !user2SW;							//Toggle user SW value
		changeSWStatus = user2SW;
		break;
	case en_User3:
//		signalId = CSM_C_ASIG_TX_User3_change_SW;
		user3SW = !user3SW;							//Toggle user SW value
		changeSWStatus = user3SW;
		break;
	case en_User4:
//		signalId = CSM_C_ASIG_TX_User4_change_SW;
		user4SW = !user4SW;							//Toggle user SW value
		changeSWStatus = user4SW;
		break;
	default:
		signalId = 0;
		break;
	}

	if (m_pCSMInterface && (signalId !=0))
	{
		returnValue = writeCSMSignal( signalId, &changeSWStatus, 1);
		if(returnValue)
			ETG_TRACE_USR4(("CSM write toggleUserChangeSW signal id: %x, value: %d ............ write Csm OK!                  ", signalId, changeSWStatus));
	}
	return returnValue;
}

/******************************************************************************/
/* FUNCTION     writeCSMCopySetting                                     		  */
/******************************************************************************/
/**
*  \brief       Function to write copy setting to csm (copy drive / copy ITS settings)
*
*  \param       csmSignalCopySetting, copystatus
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeCSMCopySetting(enCSMSignalCopySetting csmSignalCopySetting, enCopyStatus copyStatus)
{
	bool returnValue = FALSE;
	tU32 signalId = 0;
	enCopyUser eCopyUser;

	switch (csmSignalCopySetting) {
		case en_CSMSignalCopyDriveSetting:
//			signalId = CSM_C_ASIG_TX_Copy_drive_setting;
			break;
		case en_CSMSignalCopyITSSetting:
//			signalId = CSM_C_ASIG_TX_Copy_ITS_setting;
			break;
	}

	if (m_pCSMInterface)
	{
		returnValue = writeCSMSignal(signalId,
										 &copyStatus,
										 1);
		if(returnValue)
			ETG_TRACE_USR4(("CSM write CopyDriveSetting value: %d ............ write Csm OK!                  ", copyStatus));
	}
	return returnValue;
}

/******************************************************************************/
/* FUNCTION     writeCopyFromUser                                     	  */
/******************************************************************************/
/**
*  \brief       Function to write copy from user id profile
*
*  \param       userId
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeCopyFromUser(unsigned char userId)
{
	getVCANEffectvieUserID(userId);
	bool returnValue = FALSE;
	enCopyUser eCopyUser;

	switch (userId) {
		case en_User1:
			eCopyUser = en_CopyUser1;
			break;
		case en_User2:
			eCopyUser = en_CopyUser2;
			break;
		case en_User3:
			eCopyUser = en_CopyUser3;
			break;
		case en_User4:
			eCopyUser = en_CopyUser4;
			break;
		default:
			eCopyUser = en_NotCopyUser;
			break;
	}

	if (m_pCSMInterface)
	{
/*		returnValue = writeCSMSignal(CSM_C_ASIG_TX_Copy_No_From_User,
										 &eCopyUser,
										 1);*/
		if(returnValue)
			ETG_TRACE_USR4(("CSM write CopyFromUser value: %d ............ write Csm OK!                  ", eCopyUser));
	}
	return returnValue;
}

/******************************************************************************/
/* FUNCTION     writeCopyToUser                                     	  */
/******************************************************************************/
/**
*  \brief       Function to write copy to user id profile
*
*  \param       userId
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeCopyToUser(unsigned char userId)
{
	getVCANEffectvieUserID(userId);
	bool returnValue = FALSE;
	enCopyUser eCopyUser;

	switch (userId) {
		case en_User1:
			eCopyUser = en_CopyUser1;
			break;
		case en_User2:
			eCopyUser = en_CopyUser2;
			break;
		case en_User3:
			eCopyUser = en_CopyUser3;
			break;
		case en_User4:
			eCopyUser = en_CopyUser4;
			break;
		default:
			eCopyUser = en_NotCopyUser;
			break;
	}

	if (m_pCSMInterface)
	{
/*		returnValue = writeCSMSignal(CSM_C_ASIG_TX_Copy_user_No_To_User,
										 &eCopyUser,
										 1);*/
		if(returnValue)
			ETG_TRACE_USR4(("CSM write CopyToUser value: %d ............ write Csm OK!                  ", userId));
	}
	return returnValue;
}

/******************************************************************************/
/* FUNCTION     writeCSMSignal                                     		  */
/******************************************************************************/
/**
*  \brief       Function to write user change SW information value to CSM VCAN.
*
*  \param       signalId, pvNewSignalData, dataBufferLength
*
*  \return      bool - TRUE if CSM write SUCCESS, otherwise FALSE
*/
/******************************************************************************/
bool profilePIVI_VCANClient::writeCSMSignal(tU32  signalId, void *pvNewSignalData, tU8   dataBufferLength )
{
	bool returnValue = FALSE;
	tU32 csmHandle = 0;
	if (m_pCSMInterface && (signalId !=0))
	{
		if(CSM_C_NO_ERROR <= (m_pCSMInterface->CSM_lSignalWrite((tVoid *)&csmHandle,
											 (tU32) signalId,
											 (tVoid* ) pvNewSignalData,
											 (tU8) dataBufferLength,
											 (tU8) CSM_C_TX_AS_CONFIGURED) ))
		{
			returnValue = TRUE;
		}
		else
		{
			ETG_TRACE_USR4((" CSM-IF   :: _bWriteCsmSignal(): ................ write Csm failed!                           "));
		}
	}
	return returnValue;
}

void profilePIVI_VCANClient:: sendConfirmationToIDM()
{
	bool returnValue = false;
	static int messageCounter = 0; //counter starts from 0
	//returnValue = writeCSMSignal(CSM_C_ASIG_TX_Message_counter,&messageCounter,1);
	if(returnValue)
	{
		ETG_TRACE_USR4((" CSM-IF :: message counter updated, value:%d",messageCounter));
		messageCounter = !messageCounter ; //counter toggles each time when write succeed
	}
	else
	{
		ETG_TRACE_USR4((" CSM-IF :: message counter update failed"));
	}
}

}
}
