/*
 * profileDataPIVI.h
 *
 *  Created on	: 10.05.2017
 *  Author		: nrm7cob
 */

#ifndef CORE_PROFILEDATA_PIVI_H_
#define CORE_PROFILEDATA_PIVI_H_

#include <string>
#include <string.h>
#include <vector>
#include<map>
#include "core/profileData.h"

namespace profileMngr {


enum enPIVIDataID
{
	diKey=1,
	diWelcomeGuidance
};

enum enWelcomeGuidanceStatus
{
	welcomeGuidanceOff=0,
	welcomeGuidanceOn
};

// Default Data structure

struct defaultProfilePIVIConfiguration
{
	std::string _profileName;
	unsigned char _profileImageID;
	unsigned char _profileIKeyValue;
	enWelcomeGuidanceStatus _profileWelcomeGuidanceSetting;
	enUserStatus _profileStatus;

} typedef profilePIVIConf;

class profileDataPIVI
{
	public:
		//Constructor
		profileDataPIVI();

		bool Init(const unsigned char maxProfile);

		//Destructor
		virtual ~profileDataPIVI();

		//PIVI data get functions
		enWelcomeGuidanceStatus getWelcomeGuidance(unsigned char idx) const;

		const std::vector< unsigned char >& getProfileKeys(unsigned char userID);
		const std::vector<enWelcomeGuidanceStatus>& getWelcomeGuidanceSettings();

		//PIVI data set functions
		bool setKey(unsigned char idx, unsigned char profileIkey);
		bool DefsetKey(unsigned char idx, unsigned char defIkey);
		bool KeyLinkedProfileSetProfile(unsigned char key, unsigned char profile);
		bool SetDelinkUserID(unsigned char profile);
		bool KeyLinkedProfileDefset();
		bool setWelcomeGuidance(unsigned char idx, enWelcomeGuidanceStatus wgStatus);

		//Loading the data
		bool load();
		//storing the data in dp config		
		bool store();
		bool storeKeyLinkedProfile();
		bool loadKeyLinkedProfile();
		bool loadProfilesPIVI();
		
		static profileDataPIVI &getInst() {return *m_profileDataPIVI;};

		bool iskeymapped(unsigned char keyID);
		bool isKeyMappingPossible(unsigned char keyID);
		bool getWelcomeGuidance(unsigned char keyID);
		void changeActiveProfile(unsigned char toProfile,unsigned char key);
		unsigned char getUserIDMapped(unsigned char key);

		bool setWelcomeguidance(unsigned char userID,bool wgActive);
		std::vector<unsigned char> getKeyLinkedProfileList();
		std::map<unsigned char,bool> getRegisteredUserList();
		size_t getRegisteredUserCount();
	
protected:
		static void setID(enPIVIDataID id,unsigned char Profile,unsigned char *&pOut )
		{
			*pOut=id;++pOut;
			*pOut=Profile;++pOut;
		}
	private:

		unsigned char m_MaxPIVIProfiles;
		std::vector< std::vector<unsigned char> >  m_ProfileKeys;
		std::vector<unsigned char>  m_KeyPresentProfiles;
		std::vector<enWelcomeGuidanceStatus>  m_WelcomeGuidanceSettings;
		static profileDataPIVI * m_profileDataPIVI;
	};

}

#endif /* CORE_PROFILEDATA_PIVI_H_ */
