/*
 * profileDataPIVI.cpp
 *
 *  Created on	: 10.05.2017
 *  Author		: nrm7cob
 */
#include <algorithm>
 
#include <fcntl.h>
#include <pivi/config/profileDataPIVI.h>
#include <pivi/config/profilePIVIDefines.h>
#include <unistd.h>
#include <sys/stat.h>

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_usermanager_if.h"
#endif


#include "core/profileTrace.h"
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/profileDataPIVI.cpp.trc.h"
#endif


namespace profileMngr {

profileDataPIVI * profileDataPIVI::m_profileDataPIVI = NULL;

//*************************** profileData()  *********************************

profileDataPIVI::profileDataPIVI(): m_MaxPIVIProfiles(0)
{
	m_profileDataPIVI = this;
}

//*************************** Init()  *********************************
bool profileDataPIVI::Init(const unsigned char maxProfile)
{
	m_MaxPIVIProfiles=maxProfile;
	m_ProfileKeys.resize(m_MaxPIVIProfiles);
	for(int profile = 0;profile<m_MaxPIVIProfiles;profile++)
	{
		std::vector<unsigned char> keys(MAX_KEYS);
		m_ProfileKeys[profile] = keys;
	}
	m_WelcomeGuidanceSettings.resize(m_MaxPIVIProfiles);
	m_KeyPresentProfiles.resize(MAX_KEYS);
	
	return true;
}

//*************************** ~profileData()  ***********************************

profileDataPIVI::~profileDataPIVI()
{
}

//*************************** maxProfiles()  ***********************************

/*unsigned char profileDataPIVI::maxProfiles()
{
	return m_MaxProfiles;
}*/

bool profileDataPIVI::DefsetKey(unsigned char idx, unsigned char defIkey)
{
	std::vector <unsigned char> keys (MAX_KEYS);
	keys= m_ProfileKeys[idx]; 
	keys.assign(MAX_KEYS,defIkey);
	m_ProfileKeys[idx] = keys;
	return true;
}
//*************************** setKey  *******************************************************

bool profileDataPIVI::setKey(unsigned char idx, unsigned char profileIkey)
{
	ETG_TRACE_USR4(("profileDataPIVI::setKey"));
	std::vector<unsigned char> keys = m_ProfileKeys[idx];
	std::vector<unsigned char>::iterator it;
	it = std::find(keys.begin(),keys.end(),profileIkey);
	if(it != keys.end())
	{
		ETG_TRACE_USR4(("profileDataPIVI::setKey key available already"));
		//key is already available in the list //no need to update duplicate key value
	}
	else //key not available in the list
	{
		it = std::find(keys.begin(),keys.end(),KEY_NOT_USED); //find an empty place
		if(it != keys.end())
		{
			*it = profileIkey;
			m_ProfileKeys[idx] = keys;
			ETG_TRACE_USR4(("profileDataPIVI::setKey key added to the DP profilePIVI"));
		}
		else
		{
			ETG_TRACE_ERR(("profileDataPIVI::setKey DP Error"));
		}
	}
	return true;
}

bool profileDataPIVI::KeyLinkedProfileSetProfile(unsigned char key, unsigned char profile)
{
	if((KEY_NOT_USED == key) || (NO_KEYLESS_OPERATION == key))
	{
		return false;
	}
	if(profile <= PIVI_DEFAULT_PROFILE)
	{
		profile = INVALID_USER; // GUEST profile should not be linked to any key
	}
	--key;//NB:key index from VCAN is 1-4; in KeyLinkedProfile DP, key index is 0-3
	m_KeyPresentProfiles.at(key) = profile;
	ETG_TRACE_USR4(("m_KeyPresentProfiles [%d] = %d",++key,profile));
	return true;
}

bool profileDataPIVI::KeyLinkedProfileDefset()
{
	m_KeyPresentProfiles.assign(MAX_KEYS,INVALID_USER);
	return true;
}
bool profileDataPIVI::SetDelinkUserID(unsigned char profile)
{
	std::replace(m_KeyPresentProfiles.begin(),m_KeyPresentProfiles.end(),profile,(unsigned char) INVALID_USER);
	return true;
}

//*************************** setWelcomeGuidance  ********************************************

bool profileDataPIVI::setWelcomeGuidance(unsigned char idx, enWelcomeGuidanceStatus wgStatus)
{
	m_WelcomeGuidanceSettings.at(idx)=wgStatus;
	return true;
}

//*************************** getProfileKeys  ********************************************

const std::vector< unsigned char >& profileDataPIVI::getProfileKeys(unsigned char  userID)
{
	ETG_TRACE_USR4(("[FUNC]<-- getProfileKeys:%d" ,m_ProfileKeys.size()));
	return m_ProfileKeys[userID];
}

//*************************** getWelcomeGuidanceSettings  ********************************************

const std::vector<enWelcomeGuidanceStatus>& profileDataPIVI::getWelcomeGuidanceSettings()
{
	ETG_TRACE_USR4(("[FUNC]<-- getWelcomeGuidanceSettings:%d" ,m_WelcomeGuidanceSettings.size()));
	return m_WelcomeGuidanceSettings;
}

//*************************** store **************************************************************

bool profileDataPIVI::store()
{
	ETG_TRACE_USR4(("profileDataPIVI values stored:"));
	unsigned char buff[256],*pOut=buff;

	std::vector<unsigned char>::iterator it;

	for (int user=INDEX_ZEROTH_PROFILE;user < m_MaxPIVIProfiles;++user)
	{
		it = m_ProfileKeys[user].begin();
		setID(diKey,user,pOut);
		ETG_TRACE_USR4(("profileDataPIVI store Keys of profile: %d" , user));
		for(;it!=m_ProfileKeys[user].end();++it)
		{
			ETG_TRACE_USR4(("profileDataPIVI store key:%d \t",*it));
			*pOut = *it; ++pOut;
		}

		setID(diWelcomeGuidance,user,pOut);

		*pOut=m_WelcomeGuidanceSettings[user];++pOut;
	}

	dp_tclprofileMngrPIVIProfilesPIVI profileValuesPIVI;
	tS32 ret = profileValuesPIVI.s32SetData(buff,pOut-buff);
	ETG_TRACE_USR4(("profileDataPIVI:: profileValuesPIVI.s32SetData returns :%d \t",ret));

	return true;
}

bool profileDataPIVI::loadProfilesPIVI()
{

	unsigned char buff[256];
	dp_tclprofileMngrPIVIProfilesPIVI profileValuesPIVI;
	tS32 load = profileValuesPIVI.s32GetData(buff,256);
	if(load <=1)
	{
		ETG_TRACE_FATAL(("[FUNC]<-- profileDataPIVI::DP Read Error: %d\n",load));
		return false;
	}
	else
	{
		ETG_TRACE_USR4(("[FUNC]<-- profileDataPIVI::Length of DP: %d\n", load));
		if(load < PROFILE_PIVI_DP_LENGTH)
		{
			ETG_TRACE_FATAL(("profileDataPIVI::Datapool version mismatch!!! Loading default Values"));
			return false;
		}
	}

	unsigned char *pIn=buff;
	unsigned char idx=0;
	unsigned char profileIndex = INDEX_ZEROTH_PROFILE;
	//std::vector<std::vector<unsigned char> >::iterator OuterIter = m_ProfileKeys.begin();
	std::vector<unsigned char>::iterator it;
	for (;pIn-buff < load;)
	{
		switch (*pIn)
		{
		case diKey:
		{
			pIn+=2;
			std::vector<unsigned char> keys(MAX_KEYS);
			it = keys.begin();
			for(;it!=keys.end();it++)
			{
				*it = *pIn; ++pIn;
			}

			m_ProfileKeys[profileIndex] = keys;
			ETG_TRACE_USR4(("profileDataPIVI:: loadProfilesPIVI Enlisting keys of profile:%d ",profileIndex));
			for(int indx =0; indx < MAX_KEYS ;indx++)
			{
				ETG_TRACE_USR4(("profileDataPIVI:: loadProfilesPIVI keys : %d \t ",keys[indx] ));
			}
			++profileIndex;

		}
		break;

		case diWelcomeGuidance:
			m_WelcomeGuidanceSettings[pIn[1]]=(enWelcomeGuidanceStatus)pIn[2];
			ETG_TRACE_USR4(("[FUNC]<-- index diPIVIWelcomeGuidance   :%u\n ",m_WelcomeGuidanceSettings[pIn[1]]));
			pIn+=3;
			break;

		default:
			ETG_TRACE_FATAL(("[FUNC]<-- profileDataPIVI::default"));
			return false;
		}
	}

	ETG_TRACE_USR4(("[FUNC]<-- profileDataPIVI::Load the file"));

	return true;
}
//*************************** load()  ********************************************
bool profileDataPIVI::load()
{
	bool result = false;
	result = loadProfilesPIVI();
	if(!result)
	{
		ETG_TRACE_USR4(("profileDataPIVI: DP loadProfilesPIVI load error"));
		return false;
	}
	result = loadKeyLinkedProfile();
	if(!result)
	{
		ETG_TRACE_USR4(("profileDataPIVI: DP KeyLinkedProfile load error"));
		return false;
	}
	ETG_TRACE_USR4(("profileDataPIVI: DP read successful"));
	return true;
}
/******************************************************************************/
/* FUNCTION     iskeymapped                                                    */
/******************************************************************************/
/**
*  \brief       check if a the key is mapped to any of the profiles
*
*  \param       unsigned char keyID
*
*  \return      TRUE if the key is mapped to some profile ; FALSE otherwise
*/
/******************************************************************************/
bool profileDataPIVI::iskeymapped(unsigned char keyID)
{
	--keyID;//NB:key index from VCAN is 1-4; in KeyLinkedProfile DP, key index is 0-3
	bool result = false;
	if(INVALID_USER == m_KeyPresentProfiles [keyID])
	{
		result = false;
	}
	else
	{
		result =  true;
	}
	ETG_TRACE_USR4(("ProfilePIVI Profiledata iskeymapped: %d ,Mapped profile id:%d",result,m_KeyPresentProfiles[keyID]));

	return result;
}

/******************************************************************************/
/* FUNCTION     isKeyMappingPossible                                                    */
/******************************************************************************/
/**
*  \brief       To check if any empty user profile is available to map to current key
*
*  \param       unsigned char keyID
*
*  \return      TRUE if the empty user profile is available; FALSE otherwise
*/
/******************************************************************************/
bool profileDataPIVI::isKeyMappingPossible(unsigned char keyID)
{
	if((KEY_NOT_USED == keyID) || (NO_KEYLESS_OPERATION == keyID))
	{
		return false;
	}
	size_t registerdUserCount = getRegisteredUserCount();	
	bool keyMappingPossible = false;
	--keyID; //NB: key index from VCAN is 1-4; in KeyLinkedProfile DP, key index is 0-3
	if((registerdUserCount < MAX_NORMAL_PROFILE_PIVI) && (INVALID_USER == m_KeyPresentProfiles[keyID]))
	{
		keyMappingPossible = true;
	}
	else
	{
		keyMappingPossible = false;
	}
	ETG_TRACE_USR4(("Profiledata keyMappingPossible: %d ",keyMappingPossible));
	return keyMappingPossible;

}

bool profileDataPIVI::storeKeyLinkedProfile()
{
	ETG_TRACE_USR4((" profileDataPIVI::storeKeyLinkedProfile"));
	unsigned char buff[256];
	unsigned char*pOut = buff;
	std::vector<unsigned char>::iterator iter;
	for(iter = m_KeyPresentProfiles.begin();iter!= m_KeyPresentProfiles.end();iter++)
	{
		ETG_TRACE_USR4((" profileDataPIVI::KeyPresentProfiles values: %d", *iter));
		*pOut = *iter;
		++pOut;
	}
	dp_tclprofileMngrPIVIKeyLinkedProfile KeyLinkedProfiles;
	tS32 ret = KeyLinkedProfiles.s32SetData(buff,pOut-buff);
	ETG_TRACE_USR4(("profileDataPIVI:: storeKeyLinkedProfile s32SetData returns :%d \t",ret));
	return true;
}

bool profileDataPIVI::loadKeyLinkedProfile()
{
	ETG_TRACE_USR4((" profileDataPIVI::loadKeyLinkedProfile"));
	unsigned char buff[256],*pIn;
	pIn = buff;
	dp_tclprofileMngrPIVIKeyLinkedProfile KeyLinkedProfiles;
	tS32 load = KeyLinkedProfiles.s32GetData(buff,256);
	if(load <=1)
	{
	   ETG_TRACE_FATAL(("loadKeyLinkedProfile DP Read Error"));
	   return false;
	}
	else
	{
		ETG_TRACE_USR4(("loadKeyLinkedProfile Length of DP: %d\n", load));
	}

	for(int key =0 ; key < MAX_KEYS;++key)
	{
		m_KeyPresentProfiles[key] = *pIn;
		ETG_TRACE_USR4(("m_KeyPresentProfiles [ %d ] =  %d",key,m_KeyPresentProfiles[key]));
		++pIn;
	}

	return true;
}
void profileDataPIVI:: changeActiveProfile(unsigned char newUserID,unsigned char key) //update the datapools on change profile
{
	ETG_TRACE_USR4(("changeActiveProfile userID: %d key:%d",newUserID,key));

	setKey(newUserID,key); //update ProfilesPIVI DP
	store(); //DP store is not called by PM in change user case

	KeyLinkedProfileSetProfile(key,newUserID); //updates KeyLinkedProfile DP
	storeKeyLinkedProfile();//DP store is not called by PM in change user case
}
bool profileDataPIVI::setWelcomeguidance(unsigned char userID,bool wgActive)
{
	bool result = false;
	if(INVALID_USER != userID)
	{
		m_WelcomeGuidanceSettings.at(userID) = static_cast<profileMngr::enWelcomeGuidanceStatus> (wgActive);
		result = store(); // value Changed by HMI ; DP store Has to be called
	}
	ETG_TRACE_USR4(("setWelcomeguidance userID: %d wgActive: %d",userID,wgActive));
	return result;
}
bool profileDataPIVI::getWelcomeGuidance(unsigned char user)
{
	bool WGActive = true;//TRUE by default
	if(user < m_MaxPIVIProfiles )
	{
		WGActive = m_WelcomeGuidanceSettings[user];
	}
	ETG_TRACE_USR4(("getWelcomeGuidance userID: %d WGActive: %d",user,WGActive));
	return WGActive;
}
unsigned char profileDataPIVI::getUserIDMapped(unsigned char keyID)
{
	keyID --;
	unsigned char userID =  m_KeyPresentProfiles[keyID];
	ETG_TRACE_USR4(("getUserIDMapped UserID :%d",userID));
	if(userID < m_MaxPIVIProfiles )
	{
		return userID;
	}
	return PIVI_DEFAULT_PROFILE;
}

std::vector<unsigned char> profileDataPIVI:: getKeyLinkedProfileList()
{
	return m_KeyPresentProfiles;
}

std::map<unsigned char,bool> profileDataPIVI::getRegisteredUserList()
{
	ETG_TRACE_USR4(("profileDataPIVI::getRegisteredUserList"));
	//info:Guest user is always registered
	std::map<unsigned char , bool> registerdUsers;
	for(unsigned char profile = INDEX_GUEST_PROFILE+ 1 ; profile < m_MaxPIVIProfiles ;++profile)
	{
		registerdUsers[profile] = false;
		std::vector<unsigned char> currentProfilekeys = m_ProfileKeys[profile];
		for(int indx = 0 ; indx < MAX_KEYS ; ++indx)
		{
			if(KEY_NOT_USED != currentProfilekeys[indx])
			{
				registerdUsers[profile] = true;
				break;
			}
		}
	}
return registerdUsers;

}
size_t profileDataPIVI::getRegisteredUserCount()
{
	size_t registredUserCount = 0;
	std::map<unsigned char , bool> registerdUsers = getRegisteredUserList();
	std::map<unsigned char , bool>::iterator it = registerdUsers.begin();
	for(;it != registerdUsers.end(); ++it)
	{
		if(it->second == true)
		{
			++registredUserCount;
		}		
	}
	ETG_TRACE_USR4(("registredUserCount: %d\n", registredUserCount));
	return registredUserCount;
}

}//NS-end
