/* File Projectif.h
*   Component: Profile Manager
*   Project Specific Configuration & Callback interface
*   Author: de\bn81lr
*/

#ifndef PIVICONFIG_IF_H
#define PIVICONFIG_IF_H

#include "core/configInterface.h"

using namespace profileMngr;

namespace profileMngr { class profileDataPIVI;}


namespace pivi { namespace core {

class profilePIVI_VCANClient;

class Piviconfig:public profileMngr::configIF
{
public:
	Piviconfig();
	virtual void startASFClients(::boost::shared_ptr< asf::dbus::DBusConnector > & DBus,::boost::shared_ptr< asf::core::ComponentContainer > & App);

	virtual bool Init(uint8_t & startUser);
	virtual bool InitOnPowerMode(uint8_t & startUser);
	virtual bool load();
	virtual bool store();
	virtual bool doDefSet(profileMngr::profileData & Data, unsigned char UserID);
	virtual bool doDefSet(profileMngr::profileData & Data);

	//delete profile
	virtual bool deleteProfileData(profileMngr::profileData & Data,unsigned char ID);

	virtual bool doChangeName(profileMngr::profileData & Data,unsigned char ID,std::string & Name);
	virtual bool doChangeImage(profileMngr::profileData & Data,unsigned char ID,unsigned char Idx);
	virtual bool doCreateProfile(profileData & Data,unsigned char ID,const std::string & Name,unsigned char Idx);

	virtual bool isCopyProfileAllowed(profileMngr::profileData & Data,unsigned char srcID,unsigned char destID);


	//isSetProfileNameAllowed
	virtual bool isSetProfileNameAllowed(profileMngr::profileData & Data,unsigned char userID,const std::string& profileName);

	//isSetProfileImageAllowed
	virtual bool isSetProfileImageAllowed(profileMngr::profileData & Data,unsigned char userID);

	//isDeleteProfileAllowed
	virtual bool isDeleteProfileAllowed(profileMngr::profileData & Data,unsigned char userID);

	virtual bool isCreateProfileAllowed(profileData & Data,const std::string& name, unsigned char &userID);

	virtual bool isProfileChangeAllowed(unsigned char profileIDX,unsigned char activeProfile);

	virtual bool isValetModeProfileChangeAllowed(profileData & Data,unsigned char &  userId){return false;}

	virtual bool isSetValetModeAllowed(unsigned char & newUserId){return false;}

	virtual void changeToProfileCompetionStatus(actionState status, unsigned char oldUserID, unsigned char newUserID);

	virtual bool getDefaultProfile(unsigned char & defaultUserId){return false;};

	//copyProfile
	virtual void copyProfileCompletionStatus(actionState status,profileData & Data,unsigned char srcID, unsigned char destID, uint8_t & changeUser);

	//Delete Profile
	virtual void deleteProfileCompletionStataus(actionState status, unsigned char userID, uint8_t & changeUser);

	//create profile
	virtual void createProfileCompletionStatus(actionState status, unsigned char & newUserID);

	virtual unsigned char maxProfiles();

	virtual void allClientsRegistered(){;}

	static Piviconfig &getInst() {return *m_PIVIConfig;};
	
	unsigned char getDigitalAssistant(){return m_DigitalAssistant;};
	bool getLoginKeylinkStatus();

private:
	// Function to create pthread timer
	inline void startCopyTimer();

	// Function to copy timer handler
	static void  *profileCopyTimerHandler(void * pParam);

	// Function to implement startup user identification logic
	unsigned char startupUserIdentification();

	//Function to emit Default User registration VCAN signals
	void emitDefRegistrationVCANSignals();
	
	//Function to emit VCAN signals on startup User identification
	void emitVCANSignalsOnStatrtUp(unsigned char userId);

	//Function to emit VCAN signals on create new user profile
	void emitVCANSignalsOnCreateProfile(unsigned char newUserID);

	//Function to emit VCAN signals on change/switch user profile
	void emitVCANSignalsOnChangeProfile(unsigned char newUserID);

	//Function to emit VCAN signals on delete user profile
	void emitVCANSignalsOnDeleteProfile(unsigned char userID);

	//Function to emit VCAN signals on copy user profile
	void emitVCANSignalsOnCopyProfile(unsigned char srcID,unsigned char destID);

	//Function to emit VCAN signals after 2 secs on copy user profile
	void emitSignalOnCopyDriveSettingTimeout();

	//Function to emit VCAN signals after 2 secs on copy user profile
	void emitSignalOnCopyITSSettingTimeout();

	unsigned char getLastdeletedProfile();
	void setLastdeletedProfile(unsigned char userID);
	void configureDigitalAssistant();
	void updatePropertiesOnAccONTrigger();

private:
//	static pivi::core::ServicePIVI * m_pDBUSService;
	profileDataPIVI* m_PIVIData;
	static Piviconfig * m_PIVIConfig;
	profilePIVI_VCANClient *m_pVCANClient;
	unsigned char m_maxPIVIProfiles;
	unsigned char m_DigitalAssistant;
	unsigned char m_createdUser;
	bool m_InitOnPowerMode;
	unsigned char m_lastDeletedProfile;
};

} }
#endif
