/*
 * tunerSync.h
 *
 *  Created on: 28.02.2017
 *      Author: bn81lr
 */

#ifndef JSON_TUNERSYNC_H_
#define JSON_TUNERSYNC_H_

#include "online/syncObject.h"
#include <vector>

namespace profileMngr {

struct amPreset
{
	unsigned char PresetID;
	std::string Name;
	int Frequency;
	std::string TimeStamp;
};

class tunerSync:public syncObject
{
public:
	tunerSync();
	virtual ~tunerSync();

	virtual bool bMatch(const unsigned char * token, size_t length);

	virtual bool onDouble(const unsigned char * Name, size_t nameSize, double value);
	virtual bool onInt(const unsigned char * Name, size_t nameSize, long long int  value);
	virtual bool onString(const unsigned char * Name, size_t nameSize, const unsigned char* value,size_t size);
	virtual bool onBoolean(const unsigned char * Name, size_t nameSize, int value);

	virtual size_t onStore(char * pData,size_t max);
	virtual bool onSend(yajl_gen doc);

private:
	bool sendAm(int index,yajl_gen doc);
	bool sendName(int index, const char * Name,size_t nameLen,yajl_gen doc);
	int m_LoadingIndex;
	std::vector<amPreset> m_amPresets;
};

} /* namespace profileMngr */

#endif /* JSON_TUNERSYNC_H_ */
