/*****************************************************************************
* FILE:         ServiceAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _SERVICEADAPTER_H_
#define _SERVICEADAPTER_H_


#include <boost/shared_ptr.hpp>
#include "asf/core/Logger.h"
#include "AdapterBase.h"
#include "ServiceProvider.h"


namespace profileMngr
{

template < typename TProxyType >
class ServiceAdapter : public AdapterBase
{
public:
   ServiceAdapter();

   void setProxy(::boost::shared_ptr< TProxyType > proxy);
   virtual void clearProxy();

protected:
   // disable functions:
   ServiceAdapter(const ServiceAdapter&);
   ServiceAdapter& operator=(const ServiceAdapter&);

   /**
    * Returns a shared pointer to the related proxy or throws an ServiceUnavailableException in
    * case the adapter is not valid anymore
    * @return Shared pointer Reference to the proxy in use.
    */
   ::boost::shared_ptr< TProxyType > getProxy() const;
   virtual bool isProxyValid() const;
   virtual bool isProxyPaused() const;

   ::boost::shared_ptr< TProxyType > m_proxy;

   DECLARE_CLASS_LOGGER();
};

template < typename TProxyType >
ServiceAdapter<TProxyType>::ServiceAdapter()
{}

template < typename TProxyType >
::boost::shared_ptr< TProxyType > ServiceAdapter<TProxyType>::getProxy() const
{
   if (isValid())
   {
      return m_proxy;
   }
   else
   {
      throw ServiceUnavailableException("Adapter is not valid to be used");
   }
}

template < typename TProxyType >
void ServiceAdapter<TProxyType>::setProxy(::boost::shared_ptr< TProxyType> proxy)
{
   m_proxy = proxy;
}

template < typename TProxyType >
void ServiceAdapter<TProxyType>::clearProxy()
{
   m_proxy.reset();
}

template < typename TProxyType >
bool ServiceAdapter<TProxyType>::isProxyValid() const
{
   return (m_proxy && m_proxy->isAvailable());
}

template < typename TProxyType >
bool ServiceAdapter<TProxyType>::isProxyPaused() const
{
   return (m_proxy && (m_proxy->getServiceState() == ::asf::core::ServiceState__Suspended));
}


} // namespace profileMngr


#endif  // _SERVICEADAPTER_H_
