/*****************************************************************************
* FILE:         ProfileSvcAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _PROFILESVCADAPTER_H_
#define _PROFILESVCADAPTER_H_

#include <boost/shared_ptr.hpp>
#include <string>
#include <vector>

#include "asf/core/Logger.h"

#include "ServiceAdapter.h"
#include "bosch/cm/profileProxy.h"

using namespace bosch::cm::profile;
namespace profileMngr
{

class ServiceProvider;

class ProfileSvcAdapter : public ServiceAdapter< ::bosch::cm::profile::ProfileProxy>
     , public PinVerificationValidityTimeCallbackIF
	 , public PinAuthenticationDelayTimeCallbackIF
	 , public MaxPINAttemptsCallbackIF
	 , public MaxPINAttemptsBeforeDelayCallbackIF
	 , public ActiveProfileCallbackIF
	 , public PrivacyModeCallbackIF
	 , public LinkProfileCallbackIF
{
public:
   ProfileSvcAdapter();
   virtual ~ProfileSvcAdapter(){}

	virtual void onMaxPINAttemptsBeforeDelayError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayError >& error);
	virtual void onMaxPINAttemptsBeforeDelayUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayUpdate >& update);

	virtual void onMaxPINAttemptsError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsError >& error) ;
	virtual void onMaxPINAttemptsUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsUpdate >& update);

	virtual void onPinAuthenticationDelayTimeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinAuthenticationDelayTimeError >& error);
    virtual void onPinAuthenticationDelayTimeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinAuthenticationDelayTimeUpdate >& update);

	virtual void onPinVerificationValidityTimeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinVerificationValidityTimeError >& error);
	virtual void onPinVerificationValidityTimeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinVerificationValidityTimeUpdate >& update);

	virtual void onActiveProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileError >& error);
	virtual void onActiveProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileUpdate >& update);

	virtual void onPrivacyModeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PrivacyModeError >& error);
	virtual void onPrivacyModeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PrivacyModeUpdate >& update);

	virtual void onLinkProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< LinkProfileError >& error) ;
	virtual void onLinkProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< LinkProfileResponse >& response) ;


public:
	void setPINAuthenticationDelay(uint32_t delay);
	void setAuthenticationValidTime(uint32_t validTime);
	void setMaxPINAttemptsTotal(uint8_t value);
	void setMaxPINAttemptsBeforeDelay(uint8_t value);
	void setLinkProfileStatus(bool isLinked);
	void sendGetProfileTypeRequest(bosch::cm::profile::GetProfileTypesCallbackIF& cb);

	uint32_t getPINAuthenticationDelay() {return m_pinAuthenticationDelayTime ;}
	uint32_t getAuthenticationValidTime() { return m_pinVerificationValidityTime; }
	uint8_t getMaxPINAttemptsTotal() {return m_maxPINAttempts;}
	uint8_t getMaxPINAttemptsBeforeDelay() { return m_maxPINAttemptsBeforeDelay;}
	uint8_t getActiveProfile() { return m_activeProfile;}
	uint32_t getPrivacyMode() { return m_privacyMode;}

	void registerForProperties();
	void deRegisterForProperties();
private:
   // disable functions:
   ProfileSvcAdapter(const ProfileSvcAdapter&);
   ProfileSvcAdapter& operator=(const ProfileSvcAdapter&);

   uint8_t m_maxPINAttempts;
   uint8_t m_maxPINAttemptsBeforeDelay;
   uint8_t m_activeProfile;
   uint32_t m_privacyMode;

   uint32_t m_pinAuthenticationDelayTime; // Time in Units as received by ProfileMgr: milliseconds
   uint32_t m_pinVerificationValidityTime; // Time in Units as received by ProfileMgr: milliseconds

   DECLARE_CLASS_LOGGER();
};

} // namespace profileMngr


#endif  // _PROFILESVCADAPTER_H_
