/*****************************************************************************
* FILE:         IServiceAvailable.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _ISERVICEAVAILABLE_H_
#define _ISERVICEAVAILABLE_H_

namespace profileMngr {

class IServiceAvailable
{
public:
   virtual ~IServiceAvailable() {}

   /**
    * Called whenever the service state changed to state Available.
    */
   virtual void onAvailable() = 0;

   /**
    * Called whenever the service state changed to state Disconnected
    */
   virtual void onUnavailable() = 0;

   /**
    * Called whenever the service state changed to state Suspended.
    */
   virtual void onPaused() = 0;
};

} /* namespace profileMngr */

#endif  // _ISERVICEAVAILABLE_H_
