/*****************************************************************************
* FILE:         DummSvcAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _DUMMSVCADAPTER_H
#define _DUMMSVCADAPTER_H

#include <boost/shared_ptr.hpp>
#include <string>
#include <vector>

#include "asf/core/Logger.h"

#include "ServiceAdapter.h"
#include "com/bosch/cm/dumm/DummServiceProxy.h"

using namespace com::bosch::cm::dumm::DummService;

namespace profileMngr
{

class ServiceProvider;

class DummSvcAdapter : public ServiceAdapter< ::com::bosch::cm::dumm::DummService::DummServiceProxy>
{
public:
   DummSvcAdapter();

   void sendUploadDataRequest(UploadDataCallbackIF& cb, const ::std::string& jsonUploadHeader, const ::std::string& jsonUploadData);
   void sendGenCorrelationIdRequest(GenCorrelationIdCallbackIF& cb);
   act_t sendProfileLocalLinkAckRegister(ProfileLocalLinkAckCallbackIF& cb);
   bool sendProfileLocalLinkAckDeregister(act_t act);
   act_t sendProfileLocalUnLinkAckRegister(ProfileLocalUnLinkAckCallbackIF& cb);
   bool sendProfileLocalUnLinkAckDeregister(act_t act);
private:
   // disable functions:
   DummSvcAdapter(const DummSvcAdapter&);
   DummSvcAdapter& operator=(const DummSvcAdapter&);


   DECLARE_CLASS_LOGGER();
};

} // namespace profileMngr


#endif  // _DUMMSVCADAPTER_H
