/*****************************************************************************
* FILE:         ConfigMgmtSvcAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _CONFIGURATIONMGMTSVCADAPTER_H_
#define _CONFIGURATIONMGMTSVCADAPTER_H_

#include <boost/shared_ptr.hpp>
#include <string>
#include <vector>

#include "asf/core/Logger.h"

#include "ServiceAdapter.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementProxy.h"

using namespace::de::bosch::cm::ConfigManager::ConfigManagement;
namespace profileMngr
{

class ServiceProvider;

class ConfigMgmtSvcAdapter : public ServiceAdapter< ::de::bosch::cm::ConfigManager::ConfigManagement::ConfigManagementProxy>
    , public RegisterPrivateItemCallbackIF
	, public RegisterPublicItemCallbackIF
	, public UnregisterPrivateItemCallbackIF
	, public UnregisterPublicItemCallbackIF
{
public:
   ConfigMgmtSvcAdapter();

	// RegisterPrivateItemCallbackIF
	virtual void onRegisterPrivateItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< RegisterPrivateItemError >& error);
	virtual void onRegisterPrivateItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< RegisterPrivateItemResponse >& response);

	// RegisterPublicItemCallbackIF
	virtual void onRegisterPublicItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< RegisterPublicItemError >& error);
	virtual void onRegisterPublicItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< RegisterPublicItemResponse >& response);

	// UnregisterPrivateItemCallbackIF
	virtual void onUnregisterPrivateItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< UnregisterPrivateItemError >& error);
	virtual void onUnregisterPrivateItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< UnregisterPrivateItemResponse >& response);

	// UnregisterPublicItemCallbackIF
	virtual void onUnregisterPublicItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< UnregisterPublicItemError >& error);
	virtual void onUnregisterPublicItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const boost::shared_ptr< UnregisterPublicItemResponse >& response);

	void sendRegisterReqForUAM();

	void sendRegisterPrivateItemReq(std::string& privateItemName, std::string& clientDBusName, EnItemFormats dataFormat);

	void sendUnregisterPrivateItemReq(std::string& privateItemName, std::string& clientDBusName);

	void sendRegisterPublicItemReq(std::string& publicItemName, std::string& clientDBusName, EnItemFormats dataFormat);

	void sendUnregisterPublicItemReq(std::string& publicItemName, std::string& clientDBusName);

private:
   // disable functions:
   ConfigMgmtSvcAdapter(const ConfigMgmtSvcAdapter&) ;
   ConfigMgmtSvcAdapter& operator=(const ConfigMgmtSvcAdapter&);


   DECLARE_CLASS_LOGGER();
};

} // namespace profileMngr


#endif  // _CONFIGURATIONMGMTSVCADAPTER_H_
