/*****************************************************************************
* FILE:         IProperty.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _PROFILELOCALUNLINKACKPROPERTY_H_
#define _PROFILELOCALUNLINKACKPROPERTY_H_

#include <iostream>
#include <string>
#include "boost/shared_ptr.hpp"
#include "IProperty.h"
#include "com/bosch/cm/dumm/DummServiceProxy.h"
#include "online/serviceprovider/DummSvcAdapter.h"

namespace profileMngr
{
class IProfileLocalUnlinkAckData
{
public:
   virtual ~IProfileLocalUnlinkAckData() {}
   virtual void onProfileLocalUnlinkAckDataUpdate(const ::std::string& sHeader, const ::std::string& sData) = 0;
   virtual void onProfileLocalUnlinkAckDataRegError(uint8_t error) = 0;
};

class ProfileLocalUnlinkAckProperty
   : public  IProperty
   , private com::bosch::cm::dumm::DummService::ProfileLocalUnLinkAckCallbackIF
{
public:
	ProfileLocalUnlinkAckProperty(boost::shared_ptr< DummSvcAdapter > dummSvcAdapter, IProfileLocalUnlinkAckData& notifyCb);
   ~ProfileLocalUnlinkAckProperty();

   void doRegister();
   void doDeregister();

private:
   //com::bosch::cm::dumm::DummService::ProfileLocalUnLinkAckCallbackIF
	void onProfileLocalUnLinkAckError(
			const ::boost::shared_ptr< DummServiceProxy >& proxy,
			const ::boost::shared_ptr< ProfileLocalUnLinkAckError >& error);

	void onProfileLocalUnLinkAckSignal(
			const ::boost::shared_ptr< DummServiceProxy >& proxy,
			const ::boost::shared_ptr< ProfileLocalUnLinkAckSignal >& signal);

private:
   boost::shared_ptr< DummSvcAdapter > m_dummSvcAdapter;
   IProfileLocalUnlinkAckData& m_notifyCb;
   act_t m_serverAct;
};



}  //profileMngr
#endif  // _PROFILELOCALUNLINKACKPROPERTY_H_

