/******************************************************************************
 *	FILE:        : ProfileLocalUnlinkAckProperty.cpp
 *	PROJECT:     : A-IVI project
 *  SW-COMPONENT : ProfileManager
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
 *****************************************************************************/

#include <stdlib.h>
#include "ProfileLocalUnlinkAckProperty.h"
using namespace com::bosch::cm::dumm::DummService;
namespace profileMngr
{

ProfileLocalUnlinkAckProperty::ProfileLocalUnlinkAckProperty(
		boost::shared_ptr< DummSvcAdapter > dummSvcAdapter,
		IProfileLocalUnlinkAckData& notifyCb)
        : m_dummSvcAdapter(dummSvcAdapter)
        , m_notifyCb(notifyCb)
        , m_serverAct(0)
{

}

ProfileLocalUnlinkAckProperty::~ProfileLocalUnlinkAckProperty()
{
	/*lint -save -e1506*/
	// it's ok to calls doDeregister here though it's virtual
	doDeregister();
	/*lint -restore */
}

void ProfileLocalUnlinkAckProperty::doRegister()
{
	if ( m_dummSvcAdapter->isValid() )
	{
		m_serverAct = m_dummSvcAdapter->sendProfileLocalUnLinkAckRegister(*this);
		m_isActive = true;
	}
	else
	{
		m_notifyCb.onProfileLocalUnlinkAckDataRegError(1);//TODO: Check for Error codes
	}
}

void ProfileLocalUnlinkAckProperty::doDeregister()
{
   if ( m_dummSvcAdapter->isValid() )
   {
      if(m_isActive)
      {
         //LOG_INFO("UserTrafficImpactDataProperty::doDeregister()");
         m_dummSvcAdapter->sendProfileLocalUnLinkAckDeregister(m_serverAct);
      }
   }
   else
   {
      //LOG_WARN("m_rcFiAdapter is not valid anymore");
   }
   m_isActive = false;
   m_hasCurrentValue = false;
   m_serverAct = 0;
   m_dummSvcAdapter.reset();
}

void ProfileLocalUnlinkAckProperty::onProfileLocalUnLinkAckError(
		const ::boost::shared_ptr< DummServiceProxy >& proxy,
		const ::boost::shared_ptr< ProfileLocalUnLinkAckError >& error)
{
	m_notifyCb.onProfileLocalUnlinkAckDataRegError(2);
}

void ProfileLocalUnlinkAckProperty::onProfileLocalUnLinkAckSignal(
		const ::boost::shared_ptr< DummServiceProxy >& proxy,
		const ::boost::shared_ptr< ProfileLocalUnLinkAckSignal >& signal)
{
	m_notifyCb.onProfileLocalUnlinkAckDataUpdate(signal->getJsonDownloadHeader(),signal->getJsonDownloadData());
}

} // profileMngr

