/*****************************************************************************
* FILE:         IProperty.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _IPROFILELOCALLINKACKPROPERTY_H_
#define _IPROFILELOCALLINKACKPROPERTY_H_

#include <iostream>
#include <string>
#include "boost/shared_ptr.hpp"
#include "asf/core/Timer.h"
#include "IProperty.h"
#include "com/bosch/cm/dumm/DummServiceProxy.h"
#include "online/serviceprovider/DummSvcAdapter.h"

namespace profileMngr
{
class IProfileLocalLinkAckData
{
public:
   virtual ~IProfileLocalLinkAckData() {}
   virtual void onProfileLocalLinkAckDataUpdate(const ::std::string& sHeader, const ::std::string& sData) = 0;
   virtual void onProfileLocalLinkAckDataTimeout() = 0;
   virtual void onProfileLocalLinkAckDataRegError(uint8_t error) = 0;
};
using namespace ::asf::core;
class ProfileLocalLinkAckProperty
   : public  IProperty
   , public  TimerCallbackIF
   , private com::bosch::cm::dumm::DummService::ProfileLocalLinkAckCallbackIF
{
public:
	ProfileLocalLinkAckProperty(boost::shared_ptr< DummSvcAdapter > dummSvcAdapter, uint32_t value, IProfileLocalLinkAckData& notifyCb);
   ~ProfileLocalLinkAckProperty();

   virtual void onExpired(Timer& timer, ::boost::shared_ptr< TimerPayload > data);
   void startTimer();

   void doRegister();
   void doDeregister();

private:
   //com::bosch::cm::dumm::DummService::ProfileLocalLinkAckCallbackIF
	void onProfileLocalLinkAckError(
			const ::boost::shared_ptr< DummServiceProxy >& proxy,
			const ::boost::shared_ptr< ProfileLocalLinkAckError >& error);

	void onProfileLocalLinkAckSignal(
			const ::boost::shared_ptr< DummServiceProxy >& proxy,
			const ::boost::shared_ptr< ProfileLocalLinkAckSignal >& signal);

private:
   boost::shared_ptr< DummSvcAdapter > m_dummSvcAdapter;
   IProfileLocalLinkAckData& m_notifyCb;
   act_t m_serverAct;
   uint32_t m_timerValue; // in msec
   Timer m_ackTimeoutTimer;
};



}  //profileMngr
#endif  // _IPROFILELOCALLINKACKPROPERTY_H_

