/*****************************************************************************
* FILE:         IProperty.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _IPROPERTY_H_
#define _IPROPERTY_H_

namespace profileMngr
{

class IProperty
{
public:
   virtual ~IProperty() {}
   virtual void doRegister() = 0;
   virtual void doDeregister() = 0;

   IProperty() : m_isActive(false), m_hasCurrentValue(false), m_isInUse(false) {}

   virtual bool isBusy() const
   {
      return m_isActive;
   }

   bool hasCurrentValue() const
   {
      return m_hasCurrentValue;
   }

   bool isInUse() const
   {
      return m_isInUse;
   }

   void setInUse(bool inUse)
   {
      m_isInUse = inUse;
   }

protected:
   bool m_isActive;
   bool m_hasCurrentValue;
   bool m_isInUse;

};

}  //profileMngr
#endif  // _IPROPERTY_H_

