/*****************************************************************************
* FILE:         onlineFacade.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef ONLINE_APP_H
#define ONLINE_APP_H

#include <string>
#include <semaphore.h>
#include <stdint.h>
#include <vector>

#include "online/commands/LinkProfileCommand.h"
#include "online/commands/UnlinkProfileCommand.h"
#include "online/commands/GetProfileTypesCommand.h"
#include "ReplyServiceInterfaces.h"
#include "onlineData.h"

using namespace std;

namespace profileMngr {

class IServiceProvider;
class jsonParser;
class onlineData;

class onlineFacade
  : private ILinkProfileCompletion
  , private IUnlinkProfileCompletion
  , private IGetProfileTypesCompletion
{
public:
	onlineFacade(
			IServiceProvider& serviceProvider,
			ILinkProfileReply& linkProfileReply,
			IUnlinkProfileReply& unlinkProfileReply,
			IAccountNameUpdate& accountNameReply,
			IKIDUpdate& kIDReply,
			IRemoteVehicleSettingsActivationUpdate& vehcleSetngActReply
	);
	~onlineFacade();

	static onlineFacade & getInst(){return *m_pInstance;}

	void onAllServicesAvailable();

	void startLinkProfile(const uintptr_t act, const std::string& accountName, const std::string& accountPwd);
	void startUnlinkProfile(const uintptr_t act, const uint8_t userID);

	void setPINAuthenticationDelay(uint32_t delay);
	void setAuthenticationValidTime(uint32_t validTime);
	void setMaxPINAttemptsTotal(uint32_t value);
	void setMaxPINAttemptsBeforeDelay(uint32_t value);
	void setMaxSecuredProfiles(uint32_t value);
	void setLocalLinkOrderTimeout(uint32_t value);
	void setRmtVhclSttngsAct(uint32_t value);
	void setConnectionStatus(uint32_t value);

	uint32_t getPINAuthenticationDelay();
	uint32_t getAuthenticationValidTime();
	uint32_t getMaxPINAttemptsTotal();
	uint32_t getMaxPINAttemptsBeforeDelay();
	uint32_t getMaxSecuredProfiles();
	uint32_t getLocalLinkOrderTimeout();
	uint32_t getRmtVhclSttngsAct();
	uint32_t getConnectionStatus(){return m_Data.isConnectionActive();}

	const onlineData& getData(){ return m_Data ;};

private:
	// ILinkProfileCompletion - called from LinkProfileCommand
	virtual void linkProfileCompletionSuccess(uintptr_t act, resultState result);
	virtual void linkProfileCompletionError(uintptr_t act, resultState result);

	// IUnlinkProfileCompletion - called from UnlinkProfileCommand
	virtual void unlinkProfileCompletionSuccess(uintptr_t act, resultState result);
	virtual void unlinkProfileCompletionError(uintptr_t act, resultState result);

	// IGetProfileTypesCompletion - called from GetProfileTypesCommand
	virtual void getProfileTypesCompleted(bool bSuccess);

private:
	void sendAccountNameUpdate();
	void sendKIDUpdate();
	void sendLinkProfileState(bool isLinked);

private:
	static onlineFacade *m_pInstance;
	onlineData m_Data;
	IServiceProvider& m_serviceProvider;
	ILinkProfileReply&  m_linkProfileReply;
	IUnlinkProfileReply& m_unlinkProfileReply;
	IAccountNameUpdate&  m_accountNameReply;
	IKIDUpdate& m_kIDReply;
	IRemoteVehicleSettingsActivationUpdate& m_remtVehcleSettngsActReply;

	LinkProfileCommand  m_linkProfileCmd;
	UnlinkProfileCommand  m_unlinkProfileCmd;
	GetProfileTypesCommand m_getProfileTypesCmd;
};





} // ::profileMngr

#endif
