/*
 * onlineData.h
 *
 *  Created on: 23.01.2017
 *      Author: csb1kor
 */

#ifndef CORE_onlineData_H_
#define CORE_onlineData_H_

#include <string>
#include <string.h>
#include <vector>
#include <map>
#include <stdint.h>

#define GET_ONGOING_SOURCE(x) (x >> 24 & 0xFF)
#define GET_ONGOING_DEST(x) (x >> 16 & 0xFF)
#define GET_ONGOING_MODE(x) (x & 0xFF)

namespace profileMngr {

#define CHECKSUM_DIGEST_LENGTH 32

struct StorageInfo
{
	unsigned char  ID;
	unsigned long Size;
	char Key1,Key2,Key3;
	unsigned char MayorBersion;
	unsigned char MinorVersdon;
};
struct encryptData
{
	unsigned char ID;
	uint32_t Size;
	unsigned char *pData;
};
enum enDataID
{
	diactName=1,
	dikID=2,
	diNamekID=3,// both in encrypted form, name and k-ID are as sub-chunks in the encrpyted data
	diInfo=4
};

struct VariantInfo
{
	uint8_t variantID;
	uint8_t versionID;
	VariantInfo& operator=(VariantInfo& a)
	{  variantID = a.variantID; versionID = a.versionID; return *this;}
};

struct UserKIDPair
{
	std::string kID;
	uint8_t userID;
	UserKIDPair()
	{userID= 0;kID.clear();}
	UserKIDPair(uint8_t user,const std::string& KID)
	{userID= user;kID.assign(KID);}
};

class onlineData
{
	public:
		//Constructor
		onlineData();
		bool Init(uint8_t maxNumOfProfiles,VariantInfo& info);

		//Destructor
		virtual ~onlineData();

		//getName ,getkID
		std::string  getName(uint8_t iD) const;
		std::string  getkID(uint8_t iD) const;

		//getaccountNames,getkIDs
		const std::vector<std::string>& getaccountNames();
		const std::vector<std::string>& getkIDs();

		//setaccountName ,setkID
		bool setaccountName(unsigned char idx, const std::string& acntName);
		bool setkID(unsigned char idx, const std::string& kID);

		//CfgMgr Settings MaxSecuredProfiles, LocalLinkOrderTimeout
		bool setMaxSecuredProfiles(uint32_t iMaxSecProfiles);
		uint32_t getMaxSecuredProfiles();

		bool setLocalLinkOrderTimeout(uint32_t iTimeOut);
		uint32_t getLocalLinkOrderTimeout();

		bool setRemoteVehicleSettitngActivation(bool bValue);
		bool getRemoteVehicleSettitngActivation();

		void setConnectionStatus(bool value);
		bool isConnectionActive(){return m_connectionStatus ;}

		bool isvNextCommAllowed(){ return (m_connectionStatus && m_remoteVehicleSettingsActivation);}

		//Loading the data
		bool load();
		//storing the data in dp config
		bool store();
		void doDefSet();
		bool isInit() { return m_isInit; }

		bool addCorrelationID(uint8_t userID, const std::string& corrID);
		bool isCorrIDPresent(const std::string& corrID);
		bool removecorrelationID(const std::string& corrID);

	protected:
		void storestring(std::string & str,unsigned char * &pBuff);
		static void loadstring(unsigned char * &pBuff,std::string & str);

		bool checkVersionInfo(unsigned char*& buff,uint32_t len);
		void storeVersionInfo(unsigned char*& pOut);


		void setID(enDataID id,unsigned char Profile,unsigned char *&pOut )
		{
			*pOut=id;++pOut;
			*pOut=Profile;++pOut;
		}
		bool loadAccountName();

		bool loadNameAndKid(encryptData & data);
		void storeAccountNameInfo();
		encryptData storeNameAndkID();
		bool loadProfileData();
	private:
		uint32_t m_maxSecuredProfiles;
		uint32_t m_localLinkOrderTimout;
		uint32_t m_maxNumOfProfiles;
		bool m_isInit;
		bool m_remoteVehicleSettingsActivation;
		bool m_connectionStatus;
		VariantInfo m_Info;

		std::vector<std::string> m_accountNames;
		std::vector<std::string> m_kIDs;
		std::map<std::string,UserKIDPair> m_pendingCorrelationIds;
	};

}

#endif /* CORE_onlineData_H_ */
