
#ifndef JSON_UTILS_H

#define JSON_UTILS_H
#include <stddef.h>
#include <string>
#include <vector>

namespace profileMngr{

class jsonUtils
{
public:
	jsonUtils();
	~jsonUtils();

public:

	enum Status {
		OK = 0,
		NO_OK = 1
	};

	enum ErrorCode {
		MISCELLANEOUS = 0,
		NOT_AVAILABLE = 1,
		IVI_MESSAGE_IS_CORRUPTED = 2,
		BCM_MESSAGE_IS_CORRUPTED = 3,
		UNKNOWN_RESPONSE = 4,
		VEHICLE_TIME_OUT = 5,
		PIN_MISSING = 6,
		WRONG_PIN = 7,
		PIN_BLOCKED = 8,
		CUSTOMER_PRESENCE_WARNING = 9,
		VEHICLE_WAKE_UP_FAILURE = 10,
		REQUEST_TIME_OUT = 11,
		NO_PIN_CODE_MEMORISED = 12,
		ALREADY_OK = 13,
		FEATURE_NOT_AVAILABLE = 14,
		CIPHER_FAILURE = 15,
		INHIBITION_ON_BOARD = 16,
		UPLOAD_REQUEST_BUFFER_FULL = 17,
		REMOTE_ACTUATOR_BUFFER_FULL = 18,
		VNEXT_SYNCHRONIZATION_BUFFER_FULL = 19,
		BUFFER_FULL = 20,
		MQTT_HEADER_MISMATCH = 21,
		ALREADY_LINKED = 22,
		ACTION_IN_PROGRESS = 23,
		TECHNICAL_ERROR = 24,
		AUTHENTICATION_ERROR = 25,
		UNKNOWN_USER_NAME = 26,
		UNKNOWN_VIN = 27,
		UNKNOWN_HUID = 28,
		INVALID_REQUEST = 29,
		NOT_COMPATIBLE_SETTING = 30,
		UNKNOWN_SETTING_CATEGORY = 31,
		UNKNOWN_PRODUCT_ID = 32,
		UNKNOWN_SUPPLIER_ID = 33,
		UNKNOWN_BASELINE_ID = 34,
		ONE_OR_MODE_UPDATEREGIONIDS_UNKNOWN = 35,
		COULD_NOT_ADD_THE_VEHICLE_IN_THE_CAMPAIGN = 36,
		UNKNOWN_USER_ID = 37,
		UNKNOWN_DEVICE_ID = 38,
		DEVICE_ID_NOT_LINKED_TO_VEHICULE = 39,
		//TECHNICAL_ERROR = 40, It is re declared in the A-IVI Spec Error Codes itself.
		//ALREADY_LINKED = 41,
		//ACTION_IN_PROGRESS = 42,
		//AUTHENTICATION_ERROR = 43,
		MALFORMED_REQUEST = 44,
		A_VNEXT_INTERNAL_ERROR = 255
	};

public:
	static const char*  PINAUTHENTICATIONDELAY;
	static const char*  AUTHENTICATIONVALIDTIME;
	static const char*  MAXPINATTEMPTSTOTAL;
	static const char*  LOCALLINKORDERTIMEOUT;
	static const char*  MAXSECUREDPROFILES;
	static const char*  MAXRETRIESALLOWED;
	static const char*  MAXAUTHCREDENTIALSBEFOREDELAY;
	static const char*  MAXPINATTEMPTSBEFOREDELAY;
	static const char*  UAM_PINAUTHENTICATIONDELAY;
	static const char*  UAM_AUTHENTICATIONVALIDTIME;
	static const char*  UAM_MAXPINATTEMPTSTOTAL;
	static const char*  UAM_LOCALLINKORDERTIMEOUT;
	static const char*  UAM_MAXAUTHCREDENTIALSBEFOREDELAY;
	static const char*  UAM_MAXPINATTEMPTSBEFOREDELAY;
	static const char*  UAM_CREDENTIALSVALIDATIONTIMEOUT;
	static const char*  UAM_CREDENTIALSVALIDATIONDELAY;
	static const char*  UAM_REFRESHACCESSTOKENTIMEOUT;
	static const char*  UPM_MAXSECUREDPROFILES;
	static const char*  UPM_LOCALLINKORDERTIMEOUT;
	static const char*  RVS_REMOTE_VEHICLE_SETTINGS_ACTIVATION;
	static const char*  CSA_CONNECTIVITY_AND_ACTIVATION_STATUS;
	static const char*  CREDENTIALSVALIDATIONTIMEOUT;
	static const char*  CREDENTIALSVALIDATIONDELAY;
	static const char*  REFRESHACCESSTOKENTIMEOUT;
	static const char*  LOCALUNLINKTIMEOUT;
	static const char*  SYNCHRONIZATIONTIMEOUT;
	static const char*  REMOTE_VEHICLE_SETTINGS_ACTIVATION;
	static const char*  CONNECTIVITY_AND_ACTIVATION_STATUS;
	static const char*  RETRYDELAY;
	static const char*  DELAY;
	static const char*  VALIDTIME;
	static const char*  TIMEOUT;
	static const char*  MAX;
	static const char*  VALUE;
	static const char*  TOTAL;
	static const char*  STATUS;
	static const char*  GROUP_UAM;
	static const char*  GROUP_UPM;
	static const char*  GROUP_RVS;
	static const char*  GROUP_CSA;

	static const char*  UPLOCAL_LINK_ACK_STATUS;
	static const char*  UPLOCAL_UNLINK_ACK_STATUS;
	static const char*  UPLOCAL_LINK_ACK_ERRORCODE;
	static const char*  UPLOCAL_UNLINK_ACK_ERRORCODE;

	static const char*  CORRELATION_ID;

};


}


#endif
