

#include "jsonParser.h"
#include "jsonUtils.h"
#include "yajl/yajl_parse.h"
#include <yajl/yajl_gen.h>

#include <stdio.h>
#include <string.h>
#include "online/syncObject.h"
#include "core/configInterface.h"


#include <dlt/dlt.h>
DLT_IMPORT_CONTEXT(PROFILEDATA_COMPONENT);

namespace profileMngr{


#define CALL(x) ((jsonParser*)ctx)->x
#define DEF_THIS(x) jsonParser* x=(jsonParser*)ctx;

jsonParser::jsonParser():
			 m_SubLevel(0)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("json parser constructor called"));
}

bool jsonParser::Parse(const char * file,size_t size)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("Parser called"));

	yajl_callbacks callbacks =	{	jsonParser::cb_null,	jsonParser::cb_boolean,
			jsonParser::cb_int,	jsonParser::cb_float,
			NULL,	jsonParser::cb_string,
			jsonParser::cb_start_map,	jsonParser::cb_map_key,	jsonParser::cb_end_map,
			jsonParser::cb_start_array,	jsonParser::cb_end_array	};

	yajl_handle hand;
	yajl_status stat;

	hand = yajl_alloc(&callbacks, NULL, (void *) this);

	stat = yajl_parse(hand, (const unsigned char*)file, size);

	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("Parser Finished"));

	return stat==yajl_status_ok;
}

bool jsonParser::tracekeyValuePair(std::map<std::string, KeyValue> & keyValuepair)
{
	//print the value
	for (std::map<std::string,KeyValue >::iterator it=keyValuepair.begin(); it!=keyValuepair.end(); ++it)
	{
		DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("Key :"), DLT_STRING(it->first.c_str()));
		if (it->second.keyTID==ktString)
			DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("Value string :"),DLT_STRING(it->second.strVal.c_str()));
		else if(it->second.keyTID==ktInt)
			DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("Value integer:"),DLT_INT32(it->second.intVal));
		else if(it->second.keyTID==ktBool)
			DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("Value bool:"),DLT_BOOL(it->second.boolVal));
		else
			DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("Value Unknown"));

	}
	return 1;
}

bool jsonParser::getValue(std::string iKey,KeyValue& iValue)
{
	std::map<std::string,KeyValue>::iterator it;
	it = m_KeyValue.find(iKey);

	if (it!=m_KeyValue.end())
	{
		iValue=it->second;
		return 1;
	}

	return 0;
}
bool jsonParser::insert(KeyValue iValue)
{
	std::pair<std::map<std::string, KeyValue>::iterator,bool> ret;
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("insert::"), DLT_STRING(m_CurrKey.c_str()));
	ret = m_KeyValue.insert ( std::pair<std::string, KeyValue>(m_CurrKey,iValue) );
	if (ret.second==false)
	{
		DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("Error : Key Already exist::"), DLT_STRING(m_CurrKey.c_str()));
	}
	return 1;

}
bool jsonParser::onStringValue(const std::string value)
{
	KeyValue iValue;
	iValue.keyTID=ktString;
	iValue.strVal=value;

	insert(iValue);
	return 1;
}

bool jsonParser::onIntValue(int number)
{
	KeyValue iValue;
	iValue.keyTID=ktInt;
	iValue.intVal=number;

	insert(iValue);
	return 1;
}

bool jsonParser :: onBoolValue(int boolean)
{
	KeyValue iValue;
	iValue.keyTID=ktBool;
	iValue.boolVal=boolean;

	insert(iValue);
	return 1;
}

bool jsonParser::onKey(const unsigned char * key,size_t length)
{
	char * pos=strchr((char*)key,(int)'/');

	//get the key
	std::string currKey((char*)key, length);
	m_CurrKey= currKey;  //set the current key
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG, DLT_STRING("OnKey::"),DLT_STRING(m_CurrKey.c_str()));

	return true;
}

bool jsonParser::getUpLocalLinkStatus(const std::string& jsonData, uint8_t& result, uint8_t& errorcode)
{
	bool ret = false;
	reset();
	KeyValue status;
	Parse(jsonData.c_str(),jsonData.length());
	if(getValue(jsonUtils::UPLOCAL_LINK_ACK_STATUS,status))
	{
		if(status.keyTID == ktInt)
		{
			result = status.intVal;
			// Error Code is an Optional Field in the Response Message from vNext.
			// Hence the presence/absence of ErrorCode Field should not affect the Return Value
			ret = true;
			if(getValue(jsonUtils::UPLOCAL_LINK_ACK_ERRORCODE,status))
			{
				if(status.keyTID == ktInt)
					errorcode = status.intVal;
			}
		}
	}
	return ret;
}

bool jsonParser::getUpLocalUnLinkStatus(const std::string& jsonData, uint8_t& result, uint8_t& errorcode)
{
	bool ret = false;
	reset();
	KeyValue status;
	Parse(jsonData.c_str(),jsonData.length());
	if(getValue(jsonUtils::UPLOCAL_UNLINK_ACK_STATUS,status))
	{
		if(status.keyTID == ktInt)
		{
			result = status.intVal;
			// Error Code is an Optional Field in the Response Message from vNext.
			// Hence the presence/absence of ErrorCode Field should not affect the Return Value
			ret = true;
			if(getValue(jsonUtils::UPLOCAL_UNLINK_ACK_ERRORCODE,status))
			{
				if(status.keyTID == ktInt)
					errorcode = status.intVal;
			}
		}
	}
	return ret;
}

bool jsonParser::getCorrelationID(const std::string& jsonData,std::string& corrID)
{
	bool ret = false;
	reset();
	KeyValue status;
	Parse(jsonData.c_str(),jsonData.length());

	if(getValue(jsonUtils::CORRELATION_ID,status))
	{
		if(status.keyTID == ktString)
		{
			ret = true;
			corrID.assign(status.strVal);
		}
	}
	return ret;
}

//************************************************ parser callback's **********************************************************************
int jsonParser::cb_null(void* ctx)
{
	return 0;
}

int jsonParser::cb_boolean(void* ctx, int boolean)
{
	DEF_THIS(pP)
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("Boolean:"),DLT_BOOL(boolean));

	pP->onBoolValue(boolean);
	return 1;
}

int jsonParser::cb_number(void* ctx, const char* s, size_t l)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("Number:"),DLT_STRING(s));
	return 0;//should not be used. expect to use callbacks with decoded values (int, float)
}
int jsonParser::cb_int(void* ctx, long long int number)
{
	DEF_THIS(pP)
	unsigned char numbuf[100];
	memcpy(numbuf, (char*)&number, sizeof(long long));
	pP->onIntValue(number);

	return 1;
}
int jsonParser::cb_float(void* ctx, double number)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("Float :"),DLT_FLOAT64(number));
	return 1;
}

int jsonParser::cb_string(void* ctx, const unsigned char* stringVal,size_t stringLen)
{
	DEF_THIS(pP)
	std::string str((char *)stringVal, stringLen);
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("cb_string String Value  :"),DLT_STRING(str.c_str()));
	pP->onStringValue(str);

	return 1;
}

int jsonParser::cb_map_key(void* ctx, const unsigned char* stringVal,size_t stringLen)
{
	jsonParser *pP=(jsonParser*)ctx;
	std::string currKey((char*)stringVal, stringLen);
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("cb_map_key :"),DLT_STRING(currKey.c_str()),DLT_STRING("SubLevel:"),DLT_INT(pP->m_SubLevel));

	switch (pP->m_SubLevel)
	{
	case 1:
		return pP->onKey(stringVal,stringLen);
	}
	return 1;
}

int jsonParser::cb_start_map(void* ctx)
{
	++CALL(m_SubLevel);

	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("cb_start_map:"));
	return 1;
}

int jsonParser::cb_end_map(void* ctx)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("cb_end_map:"));
	--CALL(m_SubLevel);
	return 1;
}

int jsonParser::cb_start_array(void* ctx)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("cb_start_array:"));
	return 1;
}

int jsonParser::cb_end_array(void* ctx)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_DEBUG,DLT_STRING("cb_end_array:"));
	return 1;
}

}
