/*****************************************************************************
* FILE:         UnlinkProfileCommand.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _UNLINKPROFILECOMMAND_H_
#define _UNLINKPROFILECOMMAND_H_

#include <iostream>
#include <string>
#include "ICommand.h"
#include "GetProfileTypesCommand.h"
#include "boost/shared_ptr.hpp"
#include "tcu_usb_main_fiProxy.h"
#include "com/bosch/cm/dumm/DummServiceProxy.h"
#include "online/onlineStatus.h"
#include "online/serviceprovider/DummSvcAdapter.h"
#include "online/serviceprovider/ProfileSvcAdapter.h"
#include "online/property/ProfileLocalUnlinkAckProperty.h"

using namespace::asf::core;
using namespace com::bosch::cm::dumm::DummService;


namespace profileMngr
{
class onlineData;
struct IUnlinkProfileCompletion
{
   virtual ~IUnlinkProfileCompletion() {}
   virtual void unlinkProfileCompletionSuccess(uintptr_t act, resultState result) = 0;
   virtual void unlinkProfileCompletionError(uintptr_t act, resultState result) = 0;
};

class UnlinkProfileCommand: public ICommand
        , private profileMngr::IProfileLocalUnlinkAckData
 		, private com::bosch::cm::dumm::DummService::GenCorrelationIdCallbackIF
		, private com::bosch::cm::dumm::DummService::UploadDataCallbackIF
		, private IGetProfileTypesCompletion
{
public:

   UnlinkProfileCommand();
   virtual ~UnlinkProfileCommand();

   virtual void execute();

   void init(uintptr_t act,
		   uint8_t userID,
		   boost::shared_ptr< DummSvcAdapter > dummSvcAdapter,
		   boost::shared_ptr< ProfileSvcAdapter > profileSvcAdapter,
		   onlineData& data,
		   IUnlinkProfileCompletion& completionCallback);

protected:

   virtual void returnSuccess();
   virtual void returnError(resultState errorType=rsTechnicalError);
   virtual void reset();

private:
	// IGetProfileTypesCompletion - called from GetProfileTypesCommand
	virtual void getProfileTypesCompleted(bool bSuccess);

   // GenCorrelationIdCallbackIF
   void onGenCorrelationIdError(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< GenCorrelationIdError >& error);
   void onGenCorrelationIdResponse(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< GenCorrelationIdResponse >& response);

   // UploadDataCallbackIF
   void onUploadDataError(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< UploadDataError >& error);
   void onUploadDataResponse(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< UploadDataResponse >& response);

   //IProfileLocalUnlinkAckData
   void onProfileLocalUnlinkAckDataUpdate(const ::std::string& sHeader, const ::std::string& sData);
   void onProfileLocalUnlinkAckDataRegError(uint8_t error);

   //Utility functions
   void formJsonUploadHeaderAndUploadData(const std::string& correlationID,const std::string& kID, std::string& uploadHeader, std::string& uploadData);
   std::string getTimeStamp();
   bool isUnlinkProfileAllowed(uint8_t userID);

private:
   IUnlinkProfileCompletion* m_completionCallback;
   uintptr_t m_clientAct;
   uint8_t m_userID;
   onlineData* m_Data;
   boost::shared_ptr< DummSvcAdapter > m_dummSvcAdapter;
   boost::shared_ptr< ProfileSvcAdapter > m_profileSvcAdapter;
   boost::shared_ptr< ProfileLocalUnlinkAckProperty > m_profileLocalUnlinkAckProperty;
};


}  //profileMngr
#endif  // _UNLINKPROFILECOMMAND_H_

