/*****************************************************************************
* FILE:         LinkProfileCommand.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _LINKPROFILECOMMAND_H_
#define _LINKPROFILECOMMAND_H_

#include <iostream>
#include <string>
#include "ICommand.h"
#include "boost/shared_ptr.hpp"
#include "GetProfileTypesCommand.h"
#include "tcu_usb_main_fiProxy.h"
#include "com/bosch/cm/dumm/DummServiceProxy.h"
#include "online/onlineStatus.h"
#include "online/serviceprovider/DummSvcAdapter.h"
#include "online/serviceprovider/UsbTcuSvcAdapter.h"
#include "online/serviceprovider/ProfileSvcAdapter.h"
#include "online/property/ProfileLocalLinkAckProperty.h"

using namespace::asf::core;
using namespace com::bosch::cm::dumm::DummService;


namespace profileMngr
{

class onlineData;

struct ILinkProfileCompletion
{
   virtual ~ILinkProfileCompletion() {}
   virtual void linkProfileCompletionSuccess(uintptr_t act, resultState result) = 0;
   virtual void linkProfileCompletionError(uintptr_t act, resultState result) = 0;
};

class LinkProfileCommand: public ICommand
        , private profileMngr::IProfileLocalLinkAckData
        , private ::tcu_usb_main_fi::ValidateUserCredentialsCallbackIF
		, private ::tcu_usb_main_fi::DecodeIdTokenCallbackIF
		, private com::bosch::cm::dumm::DummService::GenCorrelationIdCallbackIF
		, private com::bosch::cm::dumm::DummService::UploadDataCallbackIF
		, private IGetProfileTypesCompletion
{
public:

   LinkProfileCommand();
   virtual ~LinkProfileCommand();

   virtual void execute();

   void init(uintptr_t act,
		   const std::string& userAccountName,
		   const std::string& pwd,
		   boost::shared_ptr< DummSvcAdapter > dummSvcAdapter,
		   boost::shared_ptr< UsbTcuSvcAdapter > tcuUsbSvcAdapter,
		   boost::shared_ptr< ProfileSvcAdapter > profileSvcAdapter,
		   onlineData& data,
		   ILinkProfileCompletion& completionCallback);

protected:

   virtual void returnSuccess();
   virtual void returnError(resultState errorType=rsTechnicalError);
   virtual void reset();

private:
   // IGetProfileTypesCompletion - called from GetProfileTypesCommand
   virtual void getProfileTypesCompleted(bool bSuccess);

   //ValidateUserCredentialsCallbackIF
   void onValidateUserCredentialsError(const ::boost::shared_ptr< ::tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
		   const ::boost::shared_ptr< ::tcu_usb_main_fi::ValidateUserCredentialsError >& error);
   void onValidateUserCredentialsResult(const ::boost::shared_ptr< ::tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
		   const ::boost::shared_ptr< ::tcu_usb_main_fi::ValidateUserCredentialsResult >& result);

   //DecodeIdTokenCallbackIF
	virtual void onDecodeIdTokenError(const ::boost::shared_ptr< ::tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
			const ::boost::shared_ptr< ::tcu_usb_main_fi::DecodeIdTokenError >& error);
	virtual void onDecodeIdTokenResult(const ::boost::shared_ptr< ::tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
			const ::boost::shared_ptr< ::tcu_usb_main_fi::DecodeIdTokenResult >& result);


   //GenCorrelationIdCallbackIF
   void onGenCorrelationIdError(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< GenCorrelationIdError >& error);
   void onGenCorrelationIdResponse(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< GenCorrelationIdResponse >& response);

   //UploadDataCallbackIF
   void onUploadDataError(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< UploadDataError >& error);
   void onUploadDataResponse(const ::boost::shared_ptr< DummServiceProxy >& proxy,
		   const ::boost::shared_ptr< UploadDataResponse >& response);

   //IProfileLocalLinkAckData
   void onProfileLocalLinkAckDataUpdate(const ::std::string& sHeader, const ::std::string& sData);
   void onProfileLocalLinkAckDataRegError(uint8_t error);
   void onProfileLocalLinkAckDataTimeout();

   // Utility Functions
   void formJsonUploadHeaderAndUploadData(const std::string& correlationID, std::string& uploadHeader, std::string& uploadData);
   std::string getTimeStamp();
   bool isLinkProfileAllowed();

private:
   ILinkProfileCompletion* m_completionCallback;
   std::string m_UserAccntName;
   std::string m_accountPwd;
   std::string m_KID;
   std::string m_corrID;
   uintptr_t m_clientAct;
   uint8_t m_UserID;
   boost::shared_ptr< DummSvcAdapter > m_dummSvcAdapter;
   boost::shared_ptr< UsbTcuSvcAdapter > m_UsbTcuSvcAdapter;
   boost::shared_ptr< ProfileSvcAdapter > m_profileSvcAdapter;
   onlineData* m_Data;
   boost::shared_ptr< ProfileLocalLinkAckProperty > m_profileLocalLinkAckProperty;
};


}  //profileMngr
#endif  // _LINKPROFILECOMMAND_H_

