/*****************************************************************************
* FILE:         GetProfileTypesCommand.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _GETPROFILETYPESCOMMAND_H_
#define _GETPROFILETYPESCOMMAND_H_

#include <iostream>
#include "ICommand.h"
#include "boost/shared_ptr.hpp"
#include "online/onlineStatus.h"
#include "online/serviceprovider/ProfileSvcAdapter.h"

using namespace::asf::core;

namespace profileMngr
{

struct IGetProfileTypesCompletion
{
   virtual ~IGetProfileTypesCompletion() {}
   virtual void getProfileTypesCompleted(bool bSuccess) = 0;
};

class GetProfileTypesCommand: public ICommand
        , private bosch::cm::profile::GetProfileTypesCallbackIF
{
public:

   GetProfileTypesCommand();
   virtual ~GetProfileTypesCommand();
   static GetProfileTypesCommand& getInst(){ return *m_pInstance;}

   virtual void execute();

   void init(boost::shared_ptr< ProfileSvcAdapter > profileSvcAdapter,
		   IGetProfileTypesCompletion& completionCallback);

   const ::std::vector< bosch::cm::profile::profileType >& getProfileTypes(){return m_profileTypes;}

protected:

   virtual void returnSuccess();
   virtual void returnError();
   virtual void reset();

private:
	virtual void onGetProfileTypesError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileTypesError >& error);
	virtual void onGetProfileTypesResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileTypesResponse >& response);

private:
   static GetProfileTypesCommand* m_pInstance;
   IGetProfileTypesCompletion* m_completionCallback;
   boost::shared_ptr< ProfileSvcAdapter > m_profileSvcAdapter;
   ::std::vector< bosch::cm::profile::profileType > m_profileTypes;
};


}  //profileMngr
#endif  // _GETPROFILETYPESCOMMAND_H_

