/*****************************************************************************
* FILE:         ProfileMngrOnlineDBUSServiceImpl.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _PM_PROFILEMNGRONLINEDBUSSERVICEIMPL_H
#define _PM_PROFILEMNGRONLINEDBUSSERVICEIMPL_H

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"

#include "bosch/cm/profileConnectedStub.h"
#include "online/onlineStatus.h"

namespace profileMngr {  class ConfigManager; class onlineFacade;}

namespace app { namespace core {

   using namespace::asf::core;
   using namespace bosch::cm::profileConnected;
   using namespace ::profileMngr;
   class ProfileMngrOnlineDBUSServiceImpl : public ProfileConnectedStub
   {
   public:
       ProfileMngrOnlineDBUSServiceImpl(onlineFacade& onlineFacade);
       virtual ~ProfileMngrOnlineDBUSServiceImpl();

    public:
        virtual void onDoSynchronizeProfileRequest (const ::boost::shared_ptr< DoSynchronizeProfileRequest >& request);
        virtual void onDoLinkProfileRequest (const ::boost::shared_ptr< DoLinkProfileRequest >& request);
        virtual void onDoUnlinkProfileRequest (const ::boost::shared_ptr< DoUnlinkProfileRequest >& request);

        void sendLinkProfileResponse(resultState state, uintptr_t act);
        void sendUnlinkProfileResponse(resultState state, uintptr_t act);

    private:
        bosch::cm::profileConnected::serverResult mapAsResult(profileMngr::resultState result);
        DECLARE_CLASS_LOGGER();

private:
        onlineFacade& m_facade;
        act_t m_CurrentAct;
    };

} }// namespace app { namespace core {

#endif // ifndef _PM_PROFILEMNGRONLINEDBUSSERVICEIMPL_H

