/*****************************************************************************
* FILE:         ProfileMngrOnlineDBUSServiceImpl.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#include <dlt/dlt.h>
#include "ProfileMngrOnlineDBUSServiceImpl.h"
#include "online/onlineFacade.h"

DLT_IMPORT_CONTEXT(PROFILEDATA_COMPONENT);

namespace app { namespace core {

using namespace::asf::core;
using namespace::bosch::cm::profileConnected;

DEFINE_CLASS_LOGGER_AND_LEVEL("app/core/ProfileMngrOnlineDBUSServiceImpl", ProfileMngrOnlineDBUSServiceImpl, Info);

ProfileMngrOnlineDBUSServiceImpl::ProfileMngrOnlineDBUSServiceImpl(onlineFacade& onlineFacade) : ProfileConnectedStub("profileMngrOnlineDBUSPort")
,m_facade(onlineFacade),m_CurrentAct(0)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("ProfileMngrOnlineDBUSServiceImpl constructor called"));
}

ProfileMngrOnlineDBUSServiceImpl::~ProfileMngrOnlineDBUSServiceImpl()
{

}

void ProfileMngrOnlineDBUSServiceImpl::onDoSynchronizeProfileRequest (const ::boost::shared_ptr< DoSynchronizeProfileRequest >& request)
{
	//sendDoSynchronizeProfileResponse(serverResult__SUCCESS, request->getAct());
}

void ProfileMngrOnlineDBUSServiceImpl::onDoLinkProfileRequest (const ::boost::shared_ptr< DoLinkProfileRequest >& request)
{
	m_facade.startLinkProfile(request->getAct(),request->getAccountName(),request->getPwd());
}

void ProfileMngrOnlineDBUSServiceImpl::onDoUnlinkProfileRequest (const ::boost::shared_ptr< DoUnlinkProfileRequest >& request)
{
	m_facade.startUnlinkProfile(request->getAct(),request->getUserID());
}

void ProfileMngrOnlineDBUSServiceImpl::sendLinkProfileResponse(resultState state, uintptr_t act)
{
	sendDoLinkProfileResponse(mapAsResult(state),act);
}

void ProfileMngrOnlineDBUSServiceImpl::sendUnlinkProfileResponse(resultState state, uintptr_t act)
{
	sendDoUnlinkProfileResponse(mapAsResult(state),act);
}

bosch::cm::profileConnected::serverResult ProfileMngrOnlineDBUSServiceImpl::mapAsResult(profileMngr::resultState result)
{
	bosch::cm::profileConnected::serverResult state = bosch::cm::profileConnected::serverResult__TECHNICAL_ERROR;
	switch (result)
	{
		case profileMngr::rsFailed: state =  bosch::cm::profileConnected::serverResult__FAILED;break;
		case profileMngr::rsSuccess: state =  bosch::cm::profileConnected::serverResult__SUCCESS;break;
		case profileMngr::rsPending: state =  bosch::cm::profileConnected::serverResult__ONGOING;break;
		case profileMngr::rsDenied: state =  bosch::cm::profileConnected::serverResult__ACCESS_DENIED;break;
		case profileMngr::rsConnectionTimeout: state =  bosch::cm::profileConnected::serverResult__CONNECTION_TIMEOUT;break;
		case profileMngr::rsServiceDisabled: state =  bosch::cm::profileConnected::serverResult__SERVICE_DISABLED;break;
		case profileMngr::rsUserAlreadyLinked: state =  bosch::cm::profileConnected::serverResult__USER_IS_ALREADY_LINKED;break;
		case profileMngr::rsInValidCredentials: state =  bosch::cm::profileConnected::serverResult__INVALID_CREDENTIALS;break;
		case profileMngr::rsTechnicalError: state =  bosch::cm::profileConnected::serverResult__TECHNICAL_ERROR;break;

		default: state =  bosch::cm::profileConnected::serverResult__TECHNICAL_ERROR;break;
	}
	return state;
}

}//namespace core {
}//namespace app {

