/*****************************************************************************
* FILE:         ProfileMngrConfigDataServiceImpl.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _PM_PROFILEMNGRCONFIGDATASERVICEIMPL_H
#define _PM_PROFILEMNGRCONFIGDATASERVICEIMPL_H

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"

#include "de/bosch/cm/ConfigManager/ConfigDataStub.h"

namespace profileMngr {  class ConfigManager; class onlineFacade;}

namespace app { namespace core {

using namespace::asf::core;
using namespace::de::bosch::cm::ConfigManager::ConfigData;
using namespace ::profileMngr;

class ProfileMngrConfigDataServiceImpl : public ConfigDataStub
{
public:
   ProfileMngrConfigDataServiceImpl(onlineFacade& onlineFacade);
   virtual ~ProfileMngrConfigDataServiceImpl();

   virtual void onSetPrivateItemRequest(const ::boost::shared_ptr< SetPrivateItemRequest >& payload);

   virtual void onGetPrivateItemRequest(const ::boost::shared_ptr< GetPrivateItemRequest >& payload);

   virtual void onExchangeDESCMORequest(const ::boost::shared_ptr< ExchangeDESCMORequest >& payload);

   virtual void onUpdatePublicConfigItemRequest(const ::boost::shared_ptr< UpdatePublicConfigItemRequest >& payload);

   virtual void sendSetPrivateItemResp(::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus& status, act_t act = 0) {
		ConfigDataStub::sendSetPrivateItemResponse(status, act);
	}
	virtual void sendSetPrivateItemErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
		ConfigDataStub::sendSetPrivateItemError(errorName, errorMessage, act);
	}
	virtual void sendGetPrivateItemResp(::std::vector< ::de::bosch::cm::ConfigManager::ConfigData::ConfigInfo >& privateItem, ::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus& status, act_t act = 0) {
		ConfigDataStub::sendGetPrivateItemResponse(privateItem, status, act);
	}
	virtual void sendGetPrivateItemErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
		ConfigDataStub::sendGetPrivateItemError(errorName, errorMessage, act);
	}
	virtual void sendExchangeDESCMOResp(::std::string& outPrivateItemXML, ::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus& status, act_t act = 0) {
		ConfigDataStub::sendExchangeDESCMOResponse(outPrivateItemXML, status, act);
	}
	virtual void sendExchangeDESCMOErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
		ConfigDataStub::sendExchangeDESCMOError(errorName, errorMessage, act);
	}

private:
	EnItemsStatus updatePrvCfgItemSetting(const std::string& group, const std::string& method,const std::string& key,const std::string& value);
	EnItemsStatus getPrvCfgItemSetting(const std::string& group, const std::string& method,std::vector<ConfigInfo>& info);
	EnItemsStatus updatePubCfgItemSetting(const std::string& group, const std::string& method,const std::string& key,int value);
private:
	onlineFacade& m_facade;
	act_t m_CurrentAct;

private:
	DECLARE_CLASS_LOGGER();
};

}} // namespace app{ namespace core

#endif // ifndef _PM_PROFILEMNGRCONFIGDATASERVICEIMPL_H

