/*****************************************************************************
* FILE:         pmAsfComponent.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profile manager
*----------------------------------------------------------------------------
* DESCRIPTION:  ASF Main component class
* 				includes an ASF Service and also starts up the other Service
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

#include "ProfileMngrOnlineComp.h"
#include "online/onlineTrace.h"

#include "online/onlineComponentImpl.h"

#include <dlt/dlt.h>

#include <systemd/sd-daemon.h>

DLT_DECLARE_CONTEXT(PROFILEDATA_COMPONENT);

#define DLT_APPID_PROFILE_MANAGER     "PRMG"
#define PROFILE_DLT_SERVICE_ID 0x1020  //required for InjectionCallBack

#define DLT_PROFILEMANAGER_CMD_TEST        0x0001
#define DLT_PROFILEMANAGER_CMD_LINK        0x0002

#include <dlt/dlt.h>
DLT_IMPORT_CONTEXT(PROFILEDATA_COMPONENT);

namespace app { namespace core {

ProfileMngrOnlineComp * ProfileMngrOnlineComp::m_pInst=NULL;

using namespace::asf::core;
using namespace::asf::stream;
using namespace ::profileMngr;


DEFINE_CLASS_LOGGER_AND_LEVEL("app/core/ProfileMngrOnlineComp", ProfileMngrOnlineComp, Info);


ProfileMngrOnlineComp & ProfileMngrOnlineComp::inst()
{
	if (m_pInst==NULL) exit(excNoInstane);
	return *m_pInst;
}

ProfileMngrOnlineComp::ProfileMngrOnlineComp(): BaseComponent()
{
	m_pInst=this;
	DLT_REGISTER_APP(DLT_APPID_PROFILE_MANAGER,"PROFILEDATA Registration for Logging");
	DLT_REGISTER_CONTEXT(PROFILEDATA_COMPONENT,"PRMG","PROFILEDATA context for Logging");
	DLT_REGISTER_INJECTION_CALLBACK(PROFILEDATA_COMPONENT, PROFILE_DLT_SERVICE_ID, uIntDLTTraceInjectionCallback);

	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("ProfileMngrOnlineComp constructor called"));
	m_ponlineComp = new (std::nothrow) onlineComponentImpl();
}

int ProfileMngrOnlineComp::uIntDLTTraceInjectionCallback(uint32_t service_id, void *data, uint32_t length)
{
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("ProfileMngrOnlineComp::uIntDLTTraceInjectionCallback()"));
	unsigned char  *Rxdata;
	Rxdata = static_cast<unsigned char*>(data);

	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_RAW(Rxdata,4),DLT_STRING("ProfileMngrOnlineComp::uIntDLTTraceInjectionCallback()"));

	//Data will be like
	tU32 u32MsgCode = (Rxdata[1]);

	if (u32MsgCode==DLT_PROFILEMANAGER_CMD_LINK)
	{
		int userID=Rxdata[2];
		DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("ProfileMngrOnlineComp::DLT_PROFILEMANAGER_CMD_LINK:UserID :"),DLT_INT(userID));
	}
	else if(u32MsgCode==DLT_PROFILEMANAGER_CMD_TEST)
	{
		DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("ProfileMngrOnlineComp::DLT_PROFILEMANAGER_CMD_TEST"));
	}

	return 0;
}


ProfileMngrOnlineComp::~ProfileMngrOnlineComp()
{
	delete m_ponlineComp;
	m_ponlineComp = NULL;
 }

}} // namespace org { namespace bosch { namespace cm { namespace pm {
