
#include "imgImport.h"

#include "FreeImage.h"

#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include <string.h>

size_t strlen_r(char const* str){return strlen(str);}


char ** g_ErrorMsg=NULL;

void FIErrorHandler(FREE_IMAGE_FORMAT fif,const char * message)
{
	if (g_ErrorMsg!=NULL)
	{
		size_t len=strlen(message);
		*g_ErrorMsg=new char[len+1];
		memcpy(*g_ErrorMsg,message,len);
		*g_ErrorMsg[len]=0;
	}
}


extern "C" {

iiStatus importImage(std::string FileName,unsigned short width, unsigned short height,std::string outFileName,char *& errorMsg)
{
	FreeImage_SetOutputMessage(FIErrorHandler);
	g_ErrorMsg=&errorMsg;

	FREE_IMAGE_FORMAT fmt=FreeImage_GetFileType(FileName.c_str(),0);

	if (fmt== FIF_UNKNOWN)
		fmt=FreeImage_GetFIFFromFilename(FileName.c_str());

	FIBITMAP * in=FreeImage_Load(fmt,FileName.c_str(),0);

	if (in==0)
		return iiReadError;

	uint32_t w=FreeImage_GetWidth(in),cw;
	uint32_t h=FreeImage_GetHeight(in),ch;

	if ((float)w/(float)width < (float)h/(float)height)
	{
		ch=height;
		cw=w*height/h;
	}
	else
	{
		cw=width;
		ch=h*width/w;
	}

	FIBITMAP *out=FreeImage_Rescale(in,cw,ch,FILTER_BICUBIC);

	if (out==0)
		return iiParameterError;

	bool ret=FreeImage_Save(FIF_PNG,out,outFileName.c_str(),PNG_DEFAULT);

	delete in;
	delete out;

	return (ret==true)?iiOK:iiParameterError;

}

}

