/*
 * profileTrace.cpp
 *
 *  Created on: 26.09.2017
 *      Author: bn81lr
 */

#include "core/profileTrace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

void traceN(enTraceCode tc,uint8_t level,uint32_t data)
{
	if (et_bIsTraceActive(TR_CLASS_PROFILEMANAGER_APP,level))
	{
		char buffer[6];

		memcpy(buffer,&tc,2);
		memcpy(buffer+2,&data,4);
		et_vTraceBuffer(TR_CLASS_PROFILEMANAGER_APP,level,6,buffer);
	}
}

void traceL(enTraceCode tc,uint8_t level,uint64_t data)
{
	if (et_bIsTraceActive(TR_CLASS_PROFILEMANAGER_APP,level))
	{
		char buffer[10];

		memcpy(buffer,&tc,2);
		memcpy(buffer+2,&data,8);
		et_vTraceBuffer(TR_CLASS_PROFILEMANAGER_APP,level,10,buffer);
	}
}

void traceS(enTraceCode code,uint8_t level,const char* data)
{
	if (et_bIsTraceActive(TR_CLASS_PROFILEMANAGER_APP,level))
		{
			char buffer[257];
			unsigned char len=1;

			memcpy(buffer,&code,2);
			if (data!=0)
			{
				len=strlen(data);
				memcpy(buffer+2,data,len);
			}
			else
				memset(buffer+2,0,1);
			et_vTraceBuffer(TR_CLASS_PROFILEMANAGER_APP,level,len+2,buffer);
		}
}
