/*****************************************************************************
* FILE:         profileStatus.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  helper classes representing one communication interface
* 				storing the status of one operation for that Interface
* 				The interface directly calls the onxxx methods in case a message from a client arrives
* 				Thread syncronisation only needed for access to m_ClientsInProgress member variable
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef __PROFILE_STATUS_H
#define __PROFILE_STATUS_H

#include <stdint.h>
#include <string>
#include <vector>
#include <semaphore.h>

namespace profileMngr {
class commInterface;
enum actionState
{
	asSuccess=0,
	asPending=1,
	asFailed=2,
	asLocked=3,
	asDenied=4, //used if a value on a profile could not be change (e.g. guest profile)
	asInitializing=5,
	asFileError=6,
	asDeniedDelayed=7,
	asDeniedWaiting=8,
	asCancelled=9

};


enum enInterfaceID
{
	iidDBUS=1,
	iidCCA=2
};

enum dataChangeStatus
{
	dsIdle=0,
	dsChanged=1,
	dsProfileReset=2,
	dsPrepare=3
};

enum ClientStatusUpdate
{
	csuUnknown=0,
	csuFailed=1,
	csuPrepareChange=2,
	csuUserChanged=3,
	csuUserCopied=4,
	csuUserCreated=5,
	csuImageImprted=6,
	csuUserDeleted=7
};

class Client
{
public:
	Client(unsigned int id,std::string name):m_ID(id),m_Name(name){}
	const std::string & getName() const {return m_Name;}
	bool operator ==(const Client & ref) const {	return ref.m_ID==m_ID;};
	bool operator ==(const unsigned int ID) const {	return ID==m_ID;};
	unsigned int getID(){return m_ID;}
private:
	unsigned int m_ID;
	std::string m_Name;
	Client();
};

class commInterface
{
public:
	virtual ~commInterface(){};
public: //attributes

	virtual void sendCopyProfile(unsigned char Source,unsigned char Dest)=0;
	virtual void sendDeleteProfile(unsigned char User)=0;
	virtual void sendDataUpdate(dataChangeStatus state)=0;
	virtual void sendCreateProfile(unsigned char userID) = 0;
	virtual void updatePinRequested()=0;

	virtual void updateProfileStatus()=0;
	virtual void updateProfileID()=0;
	virtual void updateProfileImage()=0;
	virtual void updateProfileName()=0;
	virtual void updatePrivacyMode()=0;
	virtual void updateActiveProfileType()=0;


public: //function results
	virtual void sendChangeProfileResult(uintptr_t act,actionState result)=0;
	virtual void senddoImportImageResult(uintptr_t act,actionState result)=0;
	virtual void sendCopyProfileResult(uintptr_t act,actionState result)=0;
	virtual void sendDeleteProfileResult(uintptr_t act,actionState result)=0;
	virtual void sendCreateProfileResult(uintptr_t act,actionState result)=0;
	virtual void sendRemoveUserImageResult(uintptr_t act,actionState result)=0;
	virtual void sendSetValetModeResult(uintptr_t act,actionState result)=0;

	virtual enInterfaceID getInterface()=0;
};


}

#endif
