/*
 * profileData.h
 *
 *  Created on: 04.11.2016
 *      Author: bn81lr
 */

#ifndef CORE_PROFILEDATA_H_
#define CORE_PROFILEDATA_H_

#include <string>
#include <string.h>
#include <vector>
#include <stdint.h>

#define GET_ONGOING_SOURCE(x) (x >> 24 & 0xFF)
#define GET_ONGOING_DEST(x) (x >> 16 & 0xFF)
#define GET_ONGOING_MODE(x) (x & 0xFF)

namespace profileMngr {

#define CHECKSUM_DIGEST_LENGTH 32

enum enDataID
{
	diName=1,
	diImage=2,
	diExtID=3,
	diStatus=4
};

enum enUserStatus
{
	usEmpty=0,
	usGuest=1,
	usNormal=2,
	usBlocked=3,
	usProtectedRemember=0x40,//Protected by Remember Me
	usProtectedPin=0x80,//Protected by Pin
	usLinkedRemember=0x41,   //Linked to vNext & Protected by Remember Me
	usLinkedPin=0x81   //Linked to vNext & Protected by Pin
};

enum profileState
{
	psUnlocked=0,
	psLocked=1,
	psLoading=2,
	psInitalize=3,
	psBlocked=4,
	psValetMode=5
};

// Default Data structure
struct defaultProfileConfiguration
{
	std::string _profileName;
	unsigned char _profileImageID;
    enUserStatus _profileStatus;
	unsigned int _profileExternalID;

} typedef profileConf;

class ProfileApp;

class profileData
{
	friend class ProfileApp;
	public:
		//Constructor
		profileData();
		bool Init(const unsigned char maxProfile);

		//Destructor
		virtual ~profileData();

		//getName ,getImage ,getStatus
		std::string  getName() const;
		unsigned char getImage() const;
		enUserStatus getStatus() const;
		uint32_t getPrivacyMode() const;


		//getImages,getnames,getProfileStatus
		const std::vector<unsigned char>& getProfileImages();
		const std::vector<std::string>& getProfileNames();
		const std::vector<profileMngr::enUserStatus>& getProfileStatus();
		const std::vector<unsigned char *> & getPINHash();
		const std::vector<unsigned char>& getPinCounter();

		//SetImage ,SetName,SetStatus
		bool setImage(unsigned char idx, unsigned char profileImage);
		bool setName(unsigned char idx, const std::string& profileName);
		bool setStatus(unsigned char idx, enUserStatus profileStatus);
		bool setPrivacyMode(uint32_t privacyMode);
		void setPINHash(uint8_t Index,unsigned char * Hash);

		//set MaxPINAttemptsBeforeDelay ,PINAuthenticationDelay ,PinVerificationValidity
		bool setMaxPINAttemptsBeforeDelay(uint8_t iMaxPINAttempts);
		uint32_t getMaxPINAttemptsBeforeDelay();

		bool setPINAuthenticationDelay(uint32_t iDelay);
		uint32_t getPINAuthenticationDelay();

		bool setPinVerificationValidity(uint32_t iValidityTime);
		uint32_t getPinVerificationValidity();

		bool setAuthenticationValidTime(uint32_t Time);
		uint32_t getAuthenticationValidTime();

		bool setValetModeStatus(bool iValetModeStatus);
		bool getValetModeStatus();


		bool storeLogoutTime(uint64_t time);
		uint64_t getLogoutTime();

        bool setLastActiveUser(uint8_t iUser);
        uint8_t getLastActiveUser();


		//setMaxAttempsBeforeDelayTimeStamp

		bool setMaxAttempsBeforeDelayTimeStamp(uint32_t iDelatyTimeStamp,unsigned char index);
		const std::vector<uint32_t>& getMaxAttempsBeforeDelayTimeStamp();

		//setMaxCounter
		void increPinCounter(unsigned char idx);

		bool setPinCounter(unsigned char idx ,unsigned char pinCounter);

		//set and get MaxPINAttemptsTotal
		bool setMaxPINAttemptsTotal(unsigned char  iMaxPinAttemptTotal);
		unsigned char getMaxPINAttemptsTotal();

		std::vector<std::string> & getStartClients(){return m_StartClients;}
		void addStartClient(std::string & val){m_StartClients.push_back(val);}
		void storeClients();

		//Loading the data
		bool load();
		//storing the data in dp config
		bool store();
		void doDefSet();

		uint8_t currentProfile(){return m_CurrentProfile;}
		bool getStartupUserChange(){return m_bStartupUserChange;}
		void setStartupUserChange(bool bReloadData){m_bStartupUserChange=bReloadData;}

		uint32_t getChangePinTimeout(){return m_ChangePinTimeout;}

		uint32_t getOngoingProfileOperation();
		bool setOngoingProfileOperation(uint8_t source, uint8_t dest,uint8_t mode);
		profileMngr::profileState getAppState(){return m_AppState;}
		uint8_t getPinRequest(){return m_pinRequest;}
	protected:
		uint8_t m_CurrentProfile;
		bool m_bStartupUserChange;
		static void storestring(std::string & str,unsigned char * &pBuff)
		{
			*pBuff=str.length();pBuff++;
			memcpy(pBuff,str.c_str(),(unsigned long)str.length());
			pBuff+=str.length();
		}
		static void loadstring(unsigned char * &pBuff,std::string & str);
		static void setID(enDataID id,unsigned char Profile,unsigned char *&pOut )
		{
			*pOut=id;++pOut;
			*pOut=Profile;++pOut;
		}
	private:
		uint8_t m_pinRequest;
		profileMngr::profileState m_AppState;
		unsigned char m_MaxProfiles;

		std::vector<std::string> m_Names;
		std::vector<unsigned char> m_Images;
		std::vector<enUserStatus>  m_ProfileStatus;
		std::vector<unsigned char*> m_PinHashes;
		std::vector<unsigned char>  m_PinCounter;

		std::vector<std::string> m_StartClients;
	//config data
		unsigned long m_ChangePinTimeout;
		uint8_t m_CheckPinCount;

		std::vector<uint32_t> m_maxAttempsBeforeDelayTimeStamp; //save the check pin time

	};

}

#endif /* CORE_PROFILEDATA_H_ */
