

#ifndef VALETMODE_H_
#define VALETMODE_H_

#include "core/jobs/job.h"

namespace profileMngr {
class ChangeUserJob;
class DeleteUserJob;
class ProfileAppIF;

class ValetModeJob:public Job
{

private:


	bool resetDestination();  //in case of failure
    bool setValetMode();
    void doChangeUser(uint8_t userId);
	void operator = (ValetModeJob & ref){};//by intention private
	ValetModeJob(ValetModeJob & ref):Job(0,0),m_IF(ref.m_IF),m_ValetModeStatus(0),m_pChangeUser(0),m_State(Initializing),m_newUserID(0),m_pDeleteUser(0){};//by intention private
	enum status
		{
			Initializing,
			SetValetMode,
			ChangeUser,
			DeleteUser,
			Finished,
		} m_State;
public:
	ValetModeJob(uintptr_t act,bool valetMode, uint32_t numClients,ProfileAppIF & IF);
	virtual ~ValetModeJob();
	virtual void updateStatus(ClientStatusUpdate &status,uint32_t clientID);
	virtual void HandleTimerExpired();

	virtual void finish();
	virtual bool stateFunction();
	virtual bool isFinished(){return m_State==Finished || (m_State != Finished && m_Result != asSuccess);}
	virtual uint32_t getTimer();
	virtual void setTimer(uint32_t Timer);
	virtual bool isTimerExpiredRequired(){return false;}

private:
	bool m_ValetModeStatus;
	ProfileAppIF & m_IF;
	ChangeUserJob *m_pChangeUser;
	DeleteUserJob *m_pDeleteUser;
	uint8_t m_newUserID;
};

}

#endif /* COPYUSER_H_ */
