/*
 * loginUser.h
 *
 *  Created on: 12.09.2017
 *      Author: bn81lr
 */

#ifndef CORE_JOBS_LOGINUSER_H_
#define CORE_JOBS_LOGINUSER_H_

#include <core/jobs/job.h>

namespace profileMngr {

class ChangeUserJob;
class ProfileAppIF;

class loginUser: public Job {
public:
	loginUser(ChangeUserJob *pChUSer,ProfileAppIF & IF);
	virtual ~loginUser();
	virtual void finish();
	virtual bool stateFunction();
	virtual void HandleTimerExpired();
	virtual uint32_t getTimer(){return m_TimerHandle;}
	virtual void setTimer(uint32_t Timer){m_TimerHandle = Timer; }
	virtual bool isFinished(){return m_State==Done || (m_State!= Done && m_Result !=asSuccess);}
	virtual void updateStatus(ClientStatusUpdate &status,uint32_t clientID);
	virtual bool isTimerExpiredRequired(){return false;}
	void loginDone();
	void Cancel();
	ChangeUserJob * getJob(){return m_pChangeUser;}
	static void getSha(std::string Pin,unsigned char * pSha);
	actionState setProfilePin(uint8_t Index,std::string Pin);
	actionState setRememberMe(uint8_t Index);
	actionState unprotectProfile(uint8_t Index);
private:
	void adaptType(uint8_t Index);
	enum enState
	{
		Init,
		RequestPin,
		ChangeUser,
		Done
	} m_State;
	ChangeUserJob *m_pChangeUser;
	ProfileAppIF & m_IF;
	bool m_bWaitingForPin;
};

} /* namespace profileMngr */

#endif /* CORE_JOBS_LOGINUSER_H_ */
