
#ifndef JOB_H
#define JOB_H

#include "core/profileStatus.h"

namespace profileMngr {

class Job
{
public:

	Job(uintptr_t act,uint32_t numClients);
	virtual ~Job();
	virtual void HandleTimerExpired()=0;
	virtual uint32_t getTimer()=0;
	virtual void setTimer(uint32_t Timer)=0;
	uint32_t clientsOpen(){return m_ClientsOpen;}
	virtual void updateStatus(ClientStatusUpdate &status,uint32_t clientID)=0;
	void setRequester(commInterface * pReq){m_pRequester=pReq;}
	virtual actionState checkResult(){return asFailed;};
	ClientStatusUpdate * details(){return m_aClientStatus;}
	uint32_t numClients(){return m_NumClients;}
	virtual void finish()=0;
	// @return: true, if a repeated call of stateFunction can change the state, false if not (e.g number of clients !=0, error occured, Job is done)
	virtual bool stateFunction()=0;
	actionState result(){return m_Result;}
	virtual bool isFinished()=0;
	virtual bool isTimerExpiredRequired(){return true;}
protected:
	void setStatus(ClientStatusUpdate &status,uint32_t clientID);
	void reset();

	actionState m_Result;
	uint32_t m_NumClients;
	uint32_t m_TimerHandle;
	ClientStatusUpdate * m_aClientStatus;
	uint32_t m_ClientsOpen;
	commInterface *m_pRequester;
	uintptr_t m_Act;

private:
	void operator = (Job & ref){};//by intention private
};

}

#endif
