
#include "job.h"
#include "core/profileTrace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/job.cpp.trc.h"
#endif

namespace profileMngr {

Job::Job(uintptr_t act,uint32_t NumClients):m_NumClients(NumClients),m_TimerHandle(0),m_ClientsOpen(NumClients),m_pRequester(0),m_Act(act),m_Result(asSuccess)
{
	m_aClientStatus=new ClientStatusUpdate[NumClients];
	memset(m_aClientStatus,0,sizeof(ClientStatusUpdate)*NumClients);
}

Job::~Job()
{
	if (m_aClientStatus!=0)
		{delete [] m_aClientStatus;m_aClientStatus=0;}
}

void Job::reset()
{
	memset(m_aClientStatus,0,m_NumClients*sizeof(ClientStatusUpdate));
	m_ClientsOpen=m_NumClients;
}

void Job::setStatus(ClientStatusUpdate &status,uint32_t clientID)
{
	if (m_aClientStatus[clientID] == 0)
	{
		if (m_ClientsOpen > 0)
			--m_ClientsOpen;
		ETG_TRACE_USR4(("Job::updateStatus %u %i", clientID,m_ClientsOpen));
	}
	else
		ETG_TRACE_USR4(("Job::updateStatus %u ", clientID));
	m_aClientStatus[clientID]=status;
}

}
