#include "core/jobs/image.h"
#include "imgImport/imgImport.h"
#include "core/profileApp.h"

#include <pthread.h>
#include <dlfcn.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sstream>
#include <unistd.h>

#include "core/profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/image.cpp.trc.h"
#endif



namespace profileMngr {

#define IMAGE_IMPORT_LIB "/opt/bosch/base/lib/libimageimport_so.so"
#define IMAGE_IMPORT_FUNC "importImage"

#define IMAGE_STORE_PATH "/var/opt/bosch/dynamic/profile"
#define IMAGE_LIB "libimgImport_so.so"
#define IMPORT_FUNC "importImage"

int (*ImageJob::m_pImportImage)(std::string FileName,unsigned short width, unsigned short height,std::string outFileName,char *& Error)=0;
pthread_t g_ImageImportThread;
void* ImageJob::m_hLib=0;

ImageJob::ImageJob(uintptr_t act,const std::string & FileName,uint32_t width,uint32_t height,uint32_t slot,bool bAssignToUser,ProfileAppIF & IF):Job(act,0),m_IF(IF),m_bStarted(false)
		,m_FileName(FileName)
		,m_Width(width)
		,m_Height(height)
		,m_Slot(slot)
		,m_bAssignToUser(bAssignToUser)

{

}


bool ImageJob::stateFunction()
{

	if (m_bStarted==false)
	{
		pthread_create(&g_ImageImportThread,0,importImgProc,this);
		if (g_ImageImportThread==0)
			{ETG_TRACE_FATAL(("importImage thread creation failed"));return false;}
		m_bStarted=true;
	}
	return false;
}

void ImageJob::finish()
{
	if (m_bStarted==true && g_ImageImportThread!=0)
		m_Result=asFailed;
	ETG_TRACE_USR4(("ImageJob::finish(): result %d",ETG_ENUM(TR_EN_ACTIONSTATE,m_Result) ));
	if (m_pRequester) m_pRequester->senddoImportImageResult(m_Act,m_Result);
}

void ImageJob::HandleTimerExpired()
{
	finish();
}

bool ImageJob::loadImgImport()
    {
		if (m_pImportImage==0)
		{
			char * err=0;
			dlerror();
			m_hLib=dlopen(IMAGE_IMPORT_LIB,RTLD_LAZY | RTLD_GLOBAL);
			err=dlerror();
			if (err!=0)
			{
                ETG_TRACE_FATAL(("loadImgImport: %s",err));
				return false;
			}

			*(void**) (&m_pImportImage)= dlsym(m_hLib,IMAGE_IMPORT_FUNC);
			err=dlerror();
			if (err != 0)
			{
				ETG_TRACE_FATAL(("loadImgImport: %s",err));
				return false;
			}
		}
    	return m_pImportImage!=0;
    }

void ImageJob::detachLib()
{
	m_pImportImage=0;
	if (m_hLib!=0)
		{dlclose(m_hLib);m_hLib=0;}
}

void * ImageJob::importImgProc(void * pParam)
{
	ImageJob &inst = *static_cast<ImageJob*> (pParam);
	inst.importImage();
	g_ImageImportThread=0;
	inst.finish();
	ProfileApp::getInst().JobDone();
	return NULL;
}
void ImageJob::importImage()
{
	uint32_t t1,t2,slot;
	char * Error=NULL;
	struct stat st;

	if (stat(IMAGE_STORE_PATH,&st)==-1)
	{
		int ret = mkdir(IMAGE_STORE_PATH,S_IRWXU| S_IXOTH | S_IROTH);//return value does not matter. if failed, there is no way to recover for this process
	}

    ETG_TRACE_COMP(("importImage %s",fileName()));
	t1=getTickCount();

	if (loadImgImport()==true)
	{
		stringstream sstr;
		slot=m_Slot;
		uint8_t user=ProfileApp::getInst().getCurrentUser();
		if (slot==0xFFFF)
			slot=user+0x80;

		sstr << slot;

		std::string outFile(IMAGE_STORE_PATH);
		outFile+="/avatar_"+std::string(sstr.str())+".png";

		iiStatus import=(iiStatus)(*m_pImportImage)(fileName(),width(),height(),outFile,Error);


		ETG_TRACE_COMP(("importImage:finished after: %i with status:%i",getTickCount()-t1,import));

		switch (import)
		{
			case iiOK:
			{
			     if (bAssign())
				 if (ProfileApp::getInst().setProfileImage(slot,user)!= asSuccess)
			     {m_Result=asDenied;return; }
			}
			break;
			case iiReadError:
			case iiWriteError:
			case iiFormatError:
				m_Result=asFileError;
				if (Error!=NULL)
					{ETG_TRACE_FATAL(("Import error: %s",Error));}
				else
					{ETG_TRACE_FATAL(("Import error"));}
				break;
			default:m_Result=asFailed;return;
		}
		return ;
	}
	else
		m_Result=asFailed;
}

bool ImageJob::deleteUserImage(unsigned short slotId)
{
	struct stat st; stringstream sstr;

    sstr << slotId;

    //Check if ProfileImage directory Exist or not
    if (stat(IMAGE_STORE_PATH,&st)==-1)
	{
		ETG_TRACE_ERR(("isImageFileExist:Image Directory not found"));
		return false;
	}
    //if exist then create the filename with slotId
    std::string outFile(IMAGE_STORE_PATH);
    outFile+="/avatar_"+std::string(sstr.str())+".png";

    ETG_TRACE_USR4(("[FUNC]<-- deleteUserImage Name : %s",outFile.c_str()));

	 //check if the file exist
	 if( access( outFile.c_str(), F_OK ) != -1 )
	 {
		int ret = remove(outFile.c_str());//return value does not matter. if failed, this process can not do anything to make it work
	 }
	 else
		 return false;

	 return true;
}
bool ImageJob::isFinished()
{


	return g_ImageImportThread==0;
}


} /* namespace profileMngr */
