
#include "core/jobs/job.h"

namespace profileMngr {
class ChangeUserJob;
class ProfileAppIF;

class DeleteUserJob:public Job
{
public:
	DeleteUserJob(uintptr_t act,uint8_t User, uint32_t numClients,ProfileAppIF & IF,bool bChangeUser=true);
	virtual ~DeleteUserJob();
	virtual void updateStatus(ClientStatusUpdate &status,uint32_t clientID);
	virtual void HandleTimerExpired();
	uint8_t user(){return m_User;}
	virtual void finish();
	virtual bool stateFunction();
	virtual bool isFinished(){return m_State==Finished || (m_State != Finished && m_Result != asSuccess);}
	virtual uint32_t getTimer();
	virtual void setTimer(uint32_t Timer);
private:
	bool doDelete();
	void sendDelete();
	enum status
	{
		Initializing,
		Deleting,
		ChangeUser,
		Finished
	} m_State;
	void operator = (DeleteUserJob & ref){};//by intention private
	DeleteUserJob(DeleteUserJob & ref):Job(0,0),m_User(0),m_IF(ref.m_IF),m_pChangeUser(0),m_State(Initializing),m_bChangeUser(true){};//by intention private
private:
	uint8_t m_User;
	ProfileAppIF & m_IF;
	ChangeUserJob *m_pChangeUser;
	bool m_bChangeUser;

};

}
