
#include "core/jobs/deleteUser.h"
#include "core/jobs/changeUser.h"
#include "core/profileApp.h"
#include "core/configInterface.h"

#include "core/profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/deleteUser.cpp.trc.h"
#endif


namespace profileMngr {

DeleteUserJob::DeleteUserJob(uintptr_t act,uint8_t User, uint32_t numClients,ProfileAppIF & IF,bool bChangeuser):Job(act,numClients),m_IF(IF),m_User(User),m_bChangeUser(bChangeuser)
{
	m_State=Initializing;
	m_pChangeUser=0;
}

DeleteUserJob::~DeleteUserJob()
{
if (m_pChangeUser!=0)
	{delete m_pChangeUser;m_pChangeUser=0;}
}

bool DeleteUserJob::doDelete()
{
	m_IF.sendProfileStatus(psLoading);
	if (m_IF.lockDP()!=true)
		return false;
	if(m_IF.clearDPUser(m_User))
	{
		m_IF.unlockDP();
		profileData & data=m_IF.getData();
		configIF::getInst().deleteProfileData(data, m_User);
		data.store();
		configIF::getInst().store();

     	m_IF.sendDeleteProfile(m_User);
	}
	else
		{m_Result=asFailed;m_IF.unlockDP();return false;}

	return true;
}

uint32_t DeleteUserJob::getTimer()
{
	return m_TimerHandle;
	//TODO: Will enable the Separate timers for each SUb Job later
	//return ((m_State != ChangeUser)?(m_TimerHandle):(m_pChangeUser->getTimer()));
}

void DeleteUserJob::setTimer(uint32_t Timer)
{
	m_TimerHandle = Timer;
	/* TODO: Will enable the Separate timers for each SUb Job later
	if(m_State != ChangeUser)
        m_TimerHandle = Timer;
	else
	    m_pChangeUser->setTimer(Timer);*/
}


bool DeleteUserJob::stateFunction()
{
	bool bSuccess=true;
	switch (m_State)
	{
	case Initializing:
		if (configIF::getInst().isDeleteProfileAllowed(m_IF.getData(),m_User)==false)
		{
			m_Result=asDenied;
			ETG_TRACE_FATAL(("Profile Delete Denied"));
			finish();
			return false;
		}
		m_State=Deleting;doDelete();
		return true;
	case Deleting:
		if (m_ClientsOpen != 0)
			return false;

		for (int k=0;k < m_NumClients;++k)
			if (m_aClientStatus[k]!= csuUserDeleted)
			{
				ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
				bSuccess=false;
			}
		if (bSuccess)
		{
			uint8_t current=m_IF.getData().currentProfile();
			uint8_t newUser=current;
			configIF::getInst().deleteProfileCompletionStataus(m_Result,m_User,newUser);
			if (m_bChangeUser && newUser!= current)
			{
				m_State=ChangeUser;
				m_pChangeUser=new ChangeUserJob(0,newUser,current,m_NumClients,m_IF,true);
				while (m_pChangeUser->stateFunction()==true) ;
				/* TODO: Will enable the Separate timers for each SUb Job later
				if (m_pChangeUser->isFinished()==false)
					m_IF.startFailTimer(m_pChangeUser);*/
				return false;
			}
			else
				m_State=Finished;
		}
		else
			m_Result=asFailed;
		finish();
		return false;
	case ChangeUser:
		do {} while (m_pChangeUser->stateFunction()==true) ;
		if (m_pChangeUser->isFinished())
		{
			if (m_pChangeUser->result()!=asSuccess)
				m_Result=m_pChangeUser->result();
			else
				m_State=Finished;
			finish();
		}
		return false;
	}
	return false;
}

void DeleteUserJob::finish()
{
	if (m_State!=Finished && m_Result==asSuccess)
		m_Result=asFailed;
	ETG_TRACE_COMP(("DeleteUserJob::Finish %u",ETG_ENUM(TR_EN_ACTIONSTATE,m_Result)));

	m_IF.sendProfileStatus(psUnlocked);
	m_IF.sendDataUpdate(dsIdle);
	m_IF.sendDeleteProfile(255);

	if (m_pRequester) m_pRequester->sendDeleteProfileResult(m_Act,m_Result);
	m_pRequester=0;//make sure, result message is only sent once otherwise ASF reset
	if (GET_ONGOING_DEST(m_IF.getData().getOngoingProfileOperation()) == m_User)
		m_IF.getData().setOngoingProfileOperation(0,0,0);//if the delete job has deleted the unfinished copyuser user, clear the storeage
}

void DeleteUserJob::HandleTimerExpired()
{
	finish();
}



void DeleteUserJob::updateStatus(ClientStatusUpdate &status,uint32_t clientID)
{
	switch (m_State)
	{
	case Deleting:
		setStatus(status,clientID);
		break;
	case ChangeUser:
		if (m_pChangeUser!=0)
			m_pChangeUser->updateStatus(status,clientID);
		break;
	}
}

}
