#include "core/jobs/job.h"
#include <string.h>

#ifndef CREATEUSERJOB_H_
#define CREATEUSERJOB_H_

namespace profileMngr {

class ProfileAppIF;
class ChangeUserJob;

class CreateUserJob:public Job
{
public:
	CreateUserJob(uintptr_t act,const std::string & name,uint8_t ImageID,uint32_t numClients,ProfileAppIF & IF);
	virtual ~CreateUserJob();
	virtual void updateStatus(ClientStatusUpdate &status,uint32_t clientID);
	uint8_t user(){return m_User;}
	virtual void finish();
	virtual void HandleTimerExpired();
	virtual bool stateFunction();
	virtual bool isFinished(){return m_State==Finished || (m_State != Finished && m_Result != asSuccess);}
	virtual uint32_t getTimer();
	virtual void setTimer(uint32_t Timer);

private:
	void create();
	bool doCreate();
	void sendCreate();
	bool resetUser();
	enum status
	{
		Initializing,
		Creating,
		ChangeUser,
		Finished,
		RecoverFromError
	} m_State;
	void operator = (CreateUserJob & ref){};//by intention private
	CreateUserJob(CreateUserJob & ref):Job(0,0),m_IF(ref.m_IF),m_Image(ref.m_Image),m_User(ref.m_User),m_pChangeUser(0),m_State(Initializing){};//by intention private
private:
	std::string m_Name;
	uint8_t m_Image;
	uint8_t m_User;
	ProfileAppIF & m_IF;
	ChangeUserJob *m_pChangeUser;
};

} /* namespace profileMngr */

#endif /* CREATEUSERJOB_H_ */
