#include "core/jobs/createUser.h"
#include "core/jobs/changeUser.h"
#include "core/profileApp.h"
#include "core/configInterface.h"

#include "core/profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/createUser.cpp.trc.h"
#endif


namespace profileMngr {

CreateUserJob::CreateUserJob(uintptr_t act,const std::string & name,uint8_t Image,uint32_t numClients,ProfileAppIF & IF):Job(act,numClients),m_IF(IF),m_Name(name),m_Image(Image)
{
	m_State=Initializing;
	m_pChangeUser=0;
	m_User=255;
}

CreateUserJob::~CreateUserJob()
{
	if (m_pChangeUser!=0)
		{delete m_pChangeUser;m_pChangeUser=0;}
}

bool CreateUserJob::doCreate()
{
	m_IF.sendProfileStatus(psLoading);
	if (m_IF.lockDP()!=true)
		return false;
	if(m_IF.clearDPUser(m_User))
	{
		m_IF.unlockDP();
		profileData & data=m_IF.getData();
		configIF::getInst().doCreateProfile(data,m_User,m_Name,m_Image);
		data.store();
		configIF::getInst().store();

     	m_IF.sendCreateProfile(m_User);
	}
	else
		{m_Result=asFailed;m_IF.unlockDP();;return false;}
	return true;
}

uint32_t CreateUserJob::getTimer()
{
	return m_TimerHandle;
	//TODO: Will enable the Separate timers for each SUb Job later
	//return ((m_State != ChangeUser)?(m_TimerHandle):(m_pChangeUser->getTimer()));
}

void CreateUserJob::setTimer(uint32_t Timer)
{
	m_TimerHandle = Timer;
	/* TODO: Will enable the Separate timers for each SUb Job later
	if(m_State != ChangeUser)
        m_TimerHandle = Timer;
	else
	    m_pChangeUser->setTimer(Timer);*/
}

bool CreateUserJob::stateFunction()
{
	bool bSuccess=true;
	switch (m_State)
	{
	case Initializing:
		if (configIF::getInst().isCreateProfileAllowed(m_IF.getData(),m_Name,m_User)==false)
		{
			m_Result=asDenied;
			ETG_TRACE_FATAL(("Profile Create Denied"));
			finish();
			return false;
		}
		m_State=Creating;doCreate();
		return true;
		break;
	case Creating:
		if (m_ClientsOpen != 0)
			return false;

		for (int k=0;k < m_NumClients;++k)
			if (m_aClientStatus[k]!= csuUserCreated)
			{
				ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
				bSuccess=false;
			}
		if (bSuccess)
			{
				uint8_t current=m_IF.getData().currentProfile();
				uint8_t newUser=current;
				configIF::getInst().createProfileCompletionStatus(m_Result,newUser);
				if (newUser!= current)
				{
					m_State=ChangeUser;
					m_pChangeUser=new ChangeUserJob(0,newUser,current,m_NumClients,m_IF,true);
					while (m_pChangeUser->stateFunction()==true);
					/* TODO: Will enable the Separate timers for each SUb Job later
					if (m_pChangeUser->isFinished()==false)
						m_IF.startFailTimer(m_pChangeUser);*/
					return false;
				}
				else
					m_State=Finished;
			}
			else
			{
				ETG_TRACE_COMP(("resetUser"));
			    if(!resetUser())
				 {
					m_Result=asFailed;
				 }
				 else
				 {
					 m_State=RecoverFromError;
					 return true;
				  }
			}


			finish();
		return false;
		break;

	case RecoverFromError:
	     {
	    	 ETG_TRACE_COMP(("RecoverFromError"));
	    	 if (m_ClientsOpen!=0)
	    	 	return false;

	    	 for (int k=0;k < m_NumClients;++k)
	    	 	if (m_aClientStatus[k]!= csuUserDeleted)
	    	 	{
	    	 		ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
	    	 		bSuccess=false;
	    	 	}
	    	 		   // here irrespective of the  bSucsess is true or false sending failed to HMI as it is just the
	    	 		   // recovery from the error but create process has already been failed by this time

	    	 	m_State=Finished;
	    	 	m_Result=asFailed;
	    	 	finish();

	    	 	return false; //end now

	    	 	break;

	     }
	case ChangeUser:
		do {} while (m_pChangeUser->stateFunction()==true) ;
		if (m_pChangeUser->isFinished())
			{
				if (m_pChangeUser->result()!=asSuccess)
					m_Result=m_pChangeUser->result();
				else
					m_State=Finished;
				finish();
			}
				return false;
		break;
	}
	return false;
}

bool CreateUserJob::resetUser()
{

	reset();

	if (m_IF.lockDP()!=true)
		return false;
	if(m_IF.clearDPUser(m_User))
	{
		ETG_TRACE_COMP(("inside resetUser"));
			m_IF.unlockDP();
			profileData & data=m_IF.getData();
			configIF::getInst().doDefSet(m_IF.getData(),m_User);
			data.store();
			configIF::getInst().store();

	     	m_IF.sendDeleteProfile(m_User);
		}
		else
			{m_Result=asFailed;m_IF.unlockDP();return false;}

		return true;

}
void CreateUserJob::finish()
{
	if (m_State!=Finished && m_Result==asSuccess)
		m_Result=asFailed;
	ETG_TRACE_COMP(("CreateUserJob::Finish %u",ETG_ENUM(TR_EN_ACTIONSTATE,m_Result)));

	m_IF.sendProfileStatus(psUnlocked);
	m_IF.sendDataUpdate(dsIdle);
	m_IF.sendCreateProfile(255);

	if (m_pRequester) m_pRequester->sendCreateProfileResult(m_Act,m_Result);
	m_pRequester=0;//make sure, result message is only sent once otherwise ASF reset
}

void CreateUserJob::HandleTimerExpired()
{
	finish();
}


void CreateUserJob::updateStatus(ClientStatusUpdate &status,uint32_t clientID)
{
	switch (m_State)
	{
	case Creating:
		setStatus(status,clientID);
		break;
	case ChangeUser:
		if (m_pChangeUser!=0)
			m_pChangeUser->updateStatus(status,clientID);
		break;
	case RecoverFromError:
			setStatus(status,clientID);
			break;

	}
}


} /* namespace profileMngr */
