

#ifndef COPYUSER_H_
#define COPYUSER_H_

#include "core/jobs/job.h"

namespace profileMngr {
class ChangeUserJob;
class ProfileAppIF;

class CopyUserJob:public Job
{

private:
	void start();
	void copy();
	bool doCopy();
	void sendCopy();
	bool resetDestination();  //in case of failure

	void operator = (CopyUserJob & ref){};//by intention private
	CopyUserJob(CopyUserJob & ref):Job(0,0),m_Source(0),m_Dest(0),m_IF(ref.m_IF),m_pChangeUser(0),m_State(Initializing){};//by intention private
	enum status
		{
			Initializing,
			PrepareData,
			Copying,
			ChangeUser,
			Finished,
			PrepareforRecover,
			RecoverFromError
		} m_State;
public:
	CopyUserJob(uintptr_t act,uint8_t source,uint8_t dest, uint32_t numClients,ProfileAppIF & IF,bool skipInit = false);
	virtual ~CopyUserJob();
	virtual void updateStatus(ClientStatusUpdate &status,uint32_t clientID);
	virtual void HandleTimerExpired();
	uint8_t source(){return m_Source;}
	uint8_t dest(){return m_Dest;}
	virtual void finish();
	virtual bool stateFunction();
	virtual bool isFinished(){return m_State==Finished || (m_State != Finished && m_Result != asSuccess);}
	virtual uint32_t getTimer();
	virtual void setTimer(uint32_t Timer);

private:
	uint8_t m_Source;
	uint8_t m_Dest;
	ProfileAppIF & m_IF;
	ChangeUserJob *m_pChangeUser;
};

}

#endif /* COPYUSER_H_ */
